import tasksRegistry from "../data/tasks-registry.json";

export interface Task {
  title: string;
  category: string;
  difficulty: "easy" | "medium" | "hard";
  description: string;
  instruction: string;
  tags: string[];
  path: string;
  updatedAt: string;
  version: string;
  author_name: string;
  demo_url?: string;
}

export async function getTasks(): Promise<Task[]> {
  return tasksRegistry as Task[];
}

export async function getTask(taskName: string): Promise<Task | null> {
  const tasks = await getTasks();
  return tasks.find((t) => t.title === taskName) || null;
}
