import skillsData from "@/data/skills-registry.json";

export interface FileNode {
  name: string;
  type: "file" | "directory";
  children?: FileNode[];
}

export interface Skill {
  id: string;
  name: string;
  description: string;
  fileStructure: FileNode[];
  path: string;
  relatedTasks?: { title: string; path: string }[];
}

export async function getAllSkills(): Promise<Skill[]> {
  return skillsData as Skill[];
}

export async function getPaginatedSkills(
  page: number,
  limit: number,
  query?: string
): Promise<{ skills: Skill[]; hasMore: boolean }> {
  let allSkills = await getAllSkills();

  if (query) {
    const lowerQuery = query.toLowerCase();
    allSkills = allSkills.filter(
      (s) =>
        s.name.toLowerCase().includes(lowerQuery) ||
        s.description.toLowerCase().includes(lowerQuery)
    );
  }

  const start = (page - 1) * limit;
  const end = start + limit;
  const resultSkills = allSkills.slice(start, end);
  const hasMore = end < allSkills.length;

  return { skills: resultSkills, hasMore };
}
