"use client";

import { Button } from "@/components/ui/button";
import {
  Popover,
  PopoverContent,
  PopoverTrigger,
} from "@/components/ui/popover";
import { Check, Copy, Share2, Twitter } from "lucide-react";
import { useState } from "react";
import { toast } from "sonner";

export function Share() {
  const [isOpen, setIsOpen] = useState(false);
  const [hasCopied, setHasCopied] = useState(false);

  const handleCopy = () => {
    navigator.clipboard.writeText(window.location.href);
    setHasCopied(true);
    toast.success("Link copied to clipboard");
    setTimeout(() => setHasCopied(false), 2000);
    setIsOpen(false);
  };

  const handleTwitterShare = () => {
    const text = document.title;
    const url = window.location.href;
    window.open(
      `https://twitter.com/intent/tweet?text=${encodeURIComponent(text)}&url=${encodeURIComponent(url)}`,
      "_blank"
    );
    setIsOpen(false);
  };

  return (
    <Popover open={isOpen} onOpenChange={setIsOpen}>
      <PopoverTrigger asChild>
        <Button variant="outline" size="sm">
          <Share2 className="h-4 w-4" />
          Share
        </Button>
      </PopoverTrigger>
      <PopoverContent align="end" className="w-[160px] p-1">
        <div className="flex flex-col gap-0.5">
          <Button
            variant="ghost"
            size="sm"
            className="justify-start gap-2 w-full h-8 px-2 font-normal"
            onClick={handleCopy}
          >
            {hasCopied ? (
              <Check className="h-4 w-4 text-green-500" />
            ) : (
              <Copy className="h-4 w-4" />
            )}
            Copy Link
          </Button>
          <Button
            variant="ghost"
            size="sm"
            className="justify-start gap-2 w-full h-8 px-2 font-normal"
            onClick={handleTwitterShare}
          >
            <Twitter className="h-4 w-4" />
            Share on X
          </Button>
        </div>
      </PopoverContent>
    </Popover>
  );
}
