"use client";

import { Input } from "@/components/ui/input";
import { Skill } from "@/utils/skills";
import { Search } from "lucide-react";
import { useMemo, useState } from "react";
import { SkillCard } from "./SkillCard";

interface SkillsWaterfallProps {
  skills: Skill[];
}

export function SkillsWaterfall({ skills }: SkillsWaterfallProps) {
  const [searchQuery, setSearchQuery] = useState("");

  const filteredSkills = useMemo(() => {
    if (!searchQuery.trim()) {
      return skills;
    }

    const lowerQuery = searchQuery.toLowerCase();
    return skills.filter(
      (skill) =>
        skill.name.toLowerCase().includes(lowerQuery) ||
        skill.description.toLowerCase().includes(lowerQuery),
    );
  }, [skills, searchQuery]);

  return (
    <div className="space-y-8">
      {/* Search Bar */}
      <div className="relative max-w-md mx-auto md:mx-0">
        <Search className="absolute left-3 top-1/2 -translate-y-1/2 w-4 h-4 text-muted-foreground" />
        <Input
          type="text"
          placeholder="Search skills…"
          value={searchQuery}
          onChange={(e) => setSearchQuery(e.target.value)}
          className="pl-10"
        />
      </div>

      {/* Waterfall Layout using CSS Columns */}
      {filteredSkills.length > 0 ? (
        <div className="columns-1 md:columns-2 lg:columns-3 gap-6">
          {filteredSkills.map((skill) => (
            <div key={skill.id} className="break-inside-avoid mb-6">
              <SkillCard skill={skill} />
            </div>
          ))}
        </div>
      ) : (
        <div className="text-center py-12 border border-dashed border-border rounded-lg">
          <p className="text-muted-foreground">
            No skills found matching your search.
          </p>
        </div>
      )}
    </div>
  );
}
