"use client";

import { Skill } from "@/utils/skills";
import {
  Card,
  CardContent,
  CardDescription,
  CardFooter,
  CardHeader,
  CardTitle,
} from "@/components/ui/card";
import { Folder, Layers } from "lucide-react";
import { FileTree } from "@/components/FileTree";
import Link from "next/link";

export function SkillCard({ skill }: { skill: Skill }) {
  return (
    <Card className="group hover:border-primary/50 transition-colors overflow-hidden text-left w-full">
      <CardHeader className="p-5 pb-2">
        <CardTitle className="text-base font-bold font-sans tracking-tight">
          {skill.name}
        </CardTitle>
        <CardDescription className="text-sm text-muted-foreground leading-relaxed line-clamp-[12]">
          {skill.description}
        </CardDescription>
      </CardHeader>

      <CardContent className="p-5 pt-2">
        <div className="border border-border/40 rounded-md bg-background/50 overflow-hidden flex flex-col">
          <div className="px-3 py-1.5 border-b border-border/40 bg-muted/30 text-[10px] font-medium text-muted-foreground uppercase tracking-wider flex items-center gap-2">
            <Folder className="w-3 h-3" aria-hidden="true" />
            File Structure
          </div>
          <div className="p-1 overflow-y-auto max-h-[200px] scrollbar-thin scrollbar-thumb-border scrollbar-track-transparent">
            <FileTree data={skill.fileStructure} parentPath={skill.path} />
          </div>
        </div>
      </CardContent>

      {skill.relatedTasks && skill.relatedTasks.length > 0 && (
        <CardFooter className="px-5 py-3 border-t border-border flex items-center gap-2 text-xs text-muted-foreground">
          <Layers className="w-3 h-3 shrink-0" aria-hidden="true" />
          <span className="shrink-0">Used by</span>
          <div className="flex gap-1.5 flex-wrap">
            {skill.relatedTasks.map((task) => (
              <Link
                key={task.path}
                href={task.path}
                className="font-medium text-foreground/80 hover:text-primary transition-colors"
              >
                {task.title}
              </Link>
            ))}
          </div>
        </CardFooter>
      )}
    </Card>
  );
}
