import { cn } from "@/lib/utils";

const LAYERS = [
  {
    id: "skills",
    title: "Skills Layer",
    label: "Skills",
    subtitle: "Applications",
    description:
      "Domain-specific capabilities and workflows that extend agent functionality. Like applications on an OS, skills provide specialized knowledge and tools for particular tasks.",
    dotColor: "bg-[#C4B5A3]",
  },
  {
    id: "harness",
    title: "Agent Harness Layer",
    label: "Agent Harness",
    subtitle: "Operating Systems",
    description:
      "The execution environment that orchestrates agents, manages tool access, and handles I/O. Analogous to an operating system that mediates between applications and hardware.",
    dotColor: "bg-[#3BB89E]",
  },
  {
    id: "models",
    title: "Models Layer",
    label: "Models",
    subtitle: "CPUs",
    description:
      "The foundational AI models that power reasoning and generation. Like CPUs, they provide the raw computational capability that upper layers build upon.",
    dotColor: "bg-[#D08050]",
  },
];

export function HowItWorks() {
  return (
    <section className="py-24 relative overflow-hidden">
      <div className="container px-4 md:px-6 mx-auto">
        <div className="text-center mb-16 space-y-4">
          <h2 className="text-3xl font-bold tracking-tight sm:text-4xl font-heading">
            How SkillsBench Works
          </h2>
          <p className="text-muted-foreground max-w-2xl mx-auto text-lg">
            SkillsBench evaluates AI agents across three abstraction layers,
            mirroring how traditional computing systems are structured.
          </p>
        </div>

        <div className="grid grid-cols-1 lg:grid-cols-2 gap-4 items-center max-w-5xl mx-auto">
          {/* Visual Diagram */}
          <div className="relative flex items-center justify-center select-none">
            <div className="relative w-[280px] h-[280px] sm:w-[320px] sm:h-[320px] md:w-[360px] md:h-[360px]">
              {/* Outer ring - Skills */}
              <div
                className="absolute inset-0 rounded-full flex items-start justify-center bg-[#C4B5A3] dark:bg-[#8A7D6D]"
                style={{ paddingTop: "8%" }}
              >
                <div className="text-center">
                  <span className="block font-bold text-base sm:text-lg text-[#3D3329] dark:text-[#E8DDD0]">
                    Skills
                  </span>
                  <span className="block text-xs sm:text-sm font-medium text-[#3D3329]/60 dark:text-[#E8DDD0]/60">
                    Applications
                  </span>
                </div>
              </div>

              {/* Middle ring - Agent Harness */}
              <div className="absolute left-1/2 bottom-0 -translate-x-1/2 w-[200px] h-[200px] sm:w-[235px] sm:h-[235px] md:w-[260px] md:h-[260px] rounded-full bg-background z-10">
                <div
                  className="w-full h-full rounded-full flex items-start justify-center bg-[#3BB89E] dark:bg-[#2A9A82]"
                  style={{ paddingTop: "8%" }}
                >
                  <div className="text-center">
                    <span className="block font-bold text-sm sm:text-base text-[#0D3D34] dark:text-[#D4F5ED]">
                      Agent Harness
                    </span>
                    <span className="block text-xs sm:text-sm font-medium text-[#0D3D34]/60 dark:text-[#D4F5ED]/60">
                      Operating Systems
                    </span>
                  </div>
                </div>
              </div>

              {/* Inner circle - Models */}
              <div className="absolute left-1/2 bottom-0 -translate-x-1/2 w-[130px] h-[130px] sm:w-[155px] sm:h-[155px] md:w-[170px] md:h-[170px] rounded-full bg-background z-20">
                <div className="w-full h-full rounded-full flex items-center justify-center bg-[#D08050] dark:bg-[#B06838]">
                  <div className="text-center">
                    <span className="block font-bold text-sm sm:text-base text-[#3D1F0D] dark:text-[#FFE0CC]">
                      Models
                    </span>
                    <span className="block text-xs sm:text-sm font-medium text-[#3D1F0D]/60 dark:text-[#FFE0CC]/60">
                      CPUs
                    </span>
                  </div>
                </div>
              </div>
            </div>
          </div>

          {/* Legend / Steps */}
          <div className="space-y-2">
            {LAYERS.map((layer, index) => (
              <div
                key={layer.id}
                className="flex gap-2 rounded-xl py-4 px-4"
              >
                {/* Dot + Line column */}
                <div className="flex flex-col items-center pt-1.5 shrink-0">
                  <div
                    className={cn(
                      "h-4 w-4 rounded-full ring-2 ring-background",
                      layer.dotColor
                    )}
                  />
                  {index !== LAYERS.length - 1 && (
                    <div className="w-px flex-1 bg-border mt-2" />
                  )}
                </div>

                <div className="space-y-2">
                  <h3 className="text-xl font-semibold font-heading">
                    {layer.title}
                  </h3>
                  <p className="text-muted-foreground leading-relaxed">
                    {layer.description}
                  </p>
                </div>
              </div>
            ))}
          </div>
        </div>
      </div>
    </section>
  );
}
