"use client";

import Squares from "@/components/Squares";
import { useTheme } from "next-themes";
import { useEffect, useState } from "react";

export function HomeBackground() {
  const [mounted, setMounted] = useState(false);
  const { theme, resolvedTheme } = useTheme();

  useEffect(() => {
    // Delay setting mounted to ensure client-side rendering
    const timer = setTimeout(() => {
      setMounted(true);
    }, 0);
    return () => clearTimeout(timer);
  }, []);

  const [colors, setColors] = useState({ borderColor: "", hoverFillColor: "" });

  useEffect(() => {
    // Update colors based on current theme variables
    const updateColors = () => {
      const style = getComputedStyle(document.documentElement);
      const foregroundVal = style.getPropertyValue("--foreground") || "#000";
      const mutedVal = style.getPropertyValue("--muted") || "transparent";

      // Use foreground color with high transparency for grid lines
      // This ensures better contrast in both light and dark modes compared to border color

      const isDark = resolvedTheme === "dark";

      // Light mode: 93% transparent (7% opacity) - subtle but visible against light gray
      // Dark mode: 85% transparent (15% opacity) - clearly visible against dark gray
      const transparency = isDark ? "85%" : "93%";

      const subtleBorder = `color-mix(in srgb, ${foregroundVal}, transparent ${transparency})`;

      setColors({
        borderColor: subtleBorder,
        hoverFillColor: mutedVal,
      });
    };

    updateColors();
    // Add listener for theme changes if needed, but resolvedTheme change triggers re-render
    // Using setTimeout to ensure DOM is updated after theme switch
    const timer = setTimeout(updateColors, 0);
    return () => clearTimeout(timer);
  }, [resolvedTheme, theme]);

  if (!mounted) {
    return (
      <div className="absolute inset-0 w-full h-full -z-50 bg-background" />
    );
  }

  return (
    <div className="absolute inset-0 w-full h-full -z-50 bg-background">
      <Squares
        direction="diagonal"
        speed={0.15}
        squareSize={40}
        borderColor={colors.borderColor}
        hoverFillColor={colors.hoverFillColor}
      />
      {/* Vignette Overlay - Reduced opacity for better visibility */}
      <div className="absolute inset-0 w-full h-full pointer-events-none bg-[radial-gradient(transparent_0%,var(--color-background)_100%)] opacity-40" />
      <div className="absolute inset-0 w-full h-full pointer-events-none bg-[radial-gradient(circle_at_center,transparent_40%,var(--background)_100%)] opacity-60" />

      {/* Bottom Fade - Reduced height and opacity to allow buttons to be seen over grid */}
      <div className="absolute bottom-0 left-0 right-0 h-24 bg-gradient-to-t from-background/90 to-transparent" />
    </div>
  );
}
