"use client";

import { Card } from "@/components/ui/card";
import { Trophy } from "lucide-react";

import { Badge } from "@/components/ui/badge";
import { Progress } from "@/components/ui/progress";

export function HeroVisual() {
  return (
    <div className="w-full max-w-md mx-auto relative group">
      {/* Main Card */}
      <Card className="bg-background border-border rounded-xl overflow-hidden relative z-10 transition-transform duration-500 group-hover:-translate-y-1">
        {/* Header */}
        <div className="px-5 py-3 border-b border-border bg-muted/10 flex justify-between items-center">
          <span className="font-semibold text-sm tracking-tight">
            Global Leaderboard
          </span>
          <div className="flex items-center gap-2">
            <span className="relative flex h-2 w-2">
              <span className="animate-ping absolute inline-flex h-full w-full rounded-full bg-green-500 opacity-75"></span>
              <span className="relative inline-flex rounded-full h-2 w-2 bg-green-500"></span>
            </span>
            <Badge
              variant="outline"
              className="text-[10px] h-5 px-1.5 font-medium bg-muted/30"
            >
              Live Updates
            </Badge>
          </div>
        </div>

        {/* List */}
        <div className="divide-y divide-border">
          {/* Rank 1 */}
          <div className="flex items-center gap-4 px-5 py-4 hover:bg-muted/20 transition-colors">
            <div className="text-sm text-muted-foreground w-4">
              01
            </div>
            <div className="flex-1 min-w-0">
              <div className="flex justify-between items-center mb-1.5">
                <span className="font-medium text-sm text-foreground">
                  GPT-4o
                </span>
                <span className="text-xs font-medium">92.4</span>
              </div>
              <Progress value={92.4} className="h-1" />
            </div>
            <Trophy className="w-4 h-4 text-yellow-500/80" />
          </div>

          {/* Rank 2 */}
          <div className="flex items-center gap-4 px-5 py-4 hover:bg-muted/20 transition-colors">
            <div className="text-sm text-muted-foreground w-4">
              02
            </div>
            <div className="flex-1 min-w-0">
              <div className="flex justify-between items-center mb-1.5">
                <span className="font-medium text-sm text-foreground">
                  Claude 3.5
                </span>
                <span className="text-xs font-medium">89.1</span>
              </div>
              <Progress
                value={89.1}
                className="h-1"
                indicatorClassName="bg-primary/70"
              />
            </div>
          </div>

          {/* Rank 3 */}
          <div className="flex items-center gap-4 px-5 py-4 hover:bg-muted/20 transition-colors">
            <div className="text-sm text-muted-foreground w-4">
              03
            </div>
            <div className="flex-1 min-w-0">
              <div className="flex justify-between items-center mb-1.5">
                <span className="font-medium text-sm text-foreground">
                  Llama 3
                </span>
                <span className="text-xs font-medium">85.8</span>
              </div>
              <Progress
                value={85.8}
                className="h-1"
                indicatorClassName="bg-primary/40"
              />
            </div>
          </div>

          {/* Rank 4 */}
          <div className="flex items-center gap-4 px-5 py-4 hover:bg-muted/20 transition-colors">
            <div className="text-sm text-muted-foreground w-4">
              04
            </div>
            <div className="flex-1 min-w-0">
              <div className="flex justify-between items-center mb-1.5">
                <span className="font-medium text-sm text-muted-foreground">
                  Mistral Large
                </span>
                <span className="text-xs text-muted-foreground">
                  82.3
                </span>
              </div>
              <Progress
                value={82.3}
                className="h-1"
                indicatorClassName="bg-muted-foreground/30"
              />
            </div>
          </div>
        </div>
      </Card>
    </div>
  );
}
