"use client";

import { Button } from "@/components/ui/button";
import { ArrowRight, Book, ChevronDown, Terminal } from "lucide-react";
import Link from "next/link";
import Squares from "@/components/Squares";
import { useTheme } from "next-themes";
import { useEffect, useState } from "react";

export function Hero() {
  const { theme, resolvedTheme } = useTheme();
  const [mounted, setMounted] = useState(false);

  useEffect(() => {
    setMounted(true);
  }, []);

  // Default colors (safe fallback)
  let borderColor = "#999999"; // Darker for visibility debugging
  let hoverFillColor = "rgba(20, 184, 166, 0.2)"; // Teal with opacity

  if (mounted) {
    const currentTheme = resolvedTheme || theme;
    if (currentTheme === "dark") {
      borderColor = "#444444"; // Lighter gray for dark mode
      hoverFillColor = "rgba(45, 212, 191, 0.1)"; // Teal-400 with very low opacity
    } else {
      borderColor = "#CCCCCC"; // Darker gray for light mode
      hoverFillColor = "rgba(20, 184, 166, 0.2)"; // Teal-500 with low opacity
    }
  }

  return (
    <section className="relative overflow-hidden pt-20 pb-16 md:pt-32 md:pb-24 min-h-half-screen flex items-center">
      <div className="absolute inset-0 -z-10 h-full w-full">
        <Squares
          direction="diagonal"
          speed={0.5}
          squareSize={40}
          borderColor={borderColor}
          hoverFillColor={hoverFillColor}
        />
      </div>

      {/* Background Gradient Orb */}
      <div className="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 size-orb bg-chart-2/20 blur-hero rounded-full -z-20 pointer-events-none" />

      <div className="container px-4 md:px-6 mx-auto">
        <div className="max-w-4xl mx-auto flex flex-col items-center text-center">
          {/* Project Title */}
          <h1 className="text-4xl md:text-5xl lg:text-6xl font-heading font-bold tracking-tight mb-4 text-foreground animate-in fade-in slide-in-from-bottom-8 duration-700 delay-100">
            SkillsBench
          </h1>

          {/* Headline */}
          <h2 className="text-2xl md:text-3xl lg:text-4xl font-heading font-semibold tracking-tight mb-4 max-w-3xl animate-in fade-in slide-in-from-bottom-8 duration-700 delay-200 text-muted-foreground/80">
            The Benchmark for <br className="hidden lg:block" />
            <span className="relative inline-block text-foreground">
              <span className="relative z-10">AI Agent Skills</span>
              <span className="absolute -bottom-1 lg:-bottom-2 left-0 right-0 h-2 lg:h-3 bg-chart-2/60 -rotate-1 -z-10"></span>
            </span>
          </h2>

          {/* Subheadline */}
          <p className="text-lg md:text-xl text-muted-foreground max-w-2xl mb-6 animate-in fade-in slide-in-from-bottom-8 duration-700 delay-300 leading-relaxed">
            A gym-style evaluation framework measuring correctness, efficiency,
            and robustness of AI agents in real-world engineering tasks.
          </p>

          <div className="flex flex-col sm:flex-row items-center justify-center gap-4 w-full sm:w-auto animate-in fade-in slide-in-from-bottom-8 duration-700 delay-500">
            <Button
              asChild
              size="lg"
              className="h-11 px-8 text-base font-medium w-full sm:w-auto group"
            >
              <Link href="/docs/getting-started">
                <Book className="mr-2 h-4 w-4" aria-hidden="true" />
                <span>Documentation</span>
                <ArrowRight className="ml-1 h-4 w-4 transition-transform group-hover:translate-x-1" aria-hidden="true" />
              </Link>
            </Button>

            <Button
              asChild
              variant="outline"
              size="lg"
              className="h-11 px-8 text-base font-medium w-full sm:w-auto"
            >
              <Link href="#leaderboard">
                <span>Leaderboard</span>
              </Link>
            </Button>


            <Button
              asChild
              variant="outline"
              size="lg"
              className="h-11 px-8 text-base font-medium w-full sm:w-auto"
            >
              <Link href="#tasks">
                <Terminal className="h-4 w-4" aria-hidden="true" />
                <span>Explore Tasks</span>
              </Link>
            </Button>
          </div>

          {/* Scroll Indicator */}
          <div className="mt-8 animate-in fade-in slide-in-from-bottom-8 duration-700 delay-700">
            <Link
              href="#leaderboard"
              className="flex flex-col items-center gap-1.5 text-sm text-muted-foreground transition-colors hover:text-foreground"
            >
              <span>View Agent Performance</span>
              <ChevronDown className="h-4 w-4 animate-bounce" aria-hidden="true" />
            </Link>
          </div>
        </div>
      </div>
    </section>
  );
}
