import { Card } from "@/components/ui/card";
import { Contributor } from "@/utils/github";
import { ExternalLink, GitPullRequest, Github } from "lucide-react";
import Image from "next/image";

interface ContributorCardProps {
  contributor: Contributor;
  rank: number;
}

export function ContributorCard({ contributor, rank }: ContributorCardProps) {
  const profileUrl = contributor.html_url;
  const prsUrl = `https://github.com/benchflow-ai/skillsbench/pulls?q=is%3Apr+author%3A${contributor.login}`;

  return (
    <Card className="group overflow-hidden">
      <div className="flex items-center gap-4 p-5">
        <Image
          src={contributor.avatar_url}
          alt={contributor.login}
          width={48}
          height={48}
          className="rounded-full ring-2 ring-border group-hover:ring-primary/50 transition-colors"
        />

        <div className="flex-1 min-w-0">
          <h3 className="text-sm font-bold font-sans truncate">
            {contributor.login}
          </h3>
          <div className="flex items-center gap-3 mt-1.5">
            <a
              href={profileUrl}
              target="_blank"
              rel="noopener noreferrer"
              className="flex items-center gap-1 text-xs text-muted-foreground hover:text-foreground transition-colors"
            >
              <Github className="w-3.5 h-3.5" />
              Profile
            </a>
            <a
              href={prsUrl}
              target="_blank"
              rel="noopener noreferrer"
              className="flex items-center gap-1 text-xs text-muted-foreground hover:text-foreground transition-colors"
            >
              <GitPullRequest className="w-3.5 h-3.5" />
              PRs
            </a>
          </div>
        </div>

        <a
          href={profileUrl}
          target="_blank"
          rel="noopener noreferrer"
        >
          <ExternalLink className="w-4 h-4 text-muted-foreground opacity-0 group-hover:opacity-100 transition-opacity" />
        </a>
      </div>
    </Card>
  );
}
