"use client";

export function ArchitectureInfographic() {
  return (
    <section className="mb-16 md:mb-20 pt-4 md:pt-8">
      <h2 className="text-xl md:text-2xl font-normal text-center mb-3 md:mb-4">
        How SkillsBench Works
      </h2>
      <p className="text-muted text-center max-w-2xl mx-auto mb-8 md:mb-12 text-sm md:text-base px-4">
        SkillsBench evaluates AI agents across three abstraction layers, mirroring how traditional computing systems are structured.
      </p>

      <div className="flex flex-col lg:flex-row items-center justify-center gap-8 md:gap-12 lg:gap-16 px-4">
        {/* Concentric circles diagram */}
        <div className="relative w-[280px] h-[280px] sm:w-[320px] sm:h-[320px] md:w-[380px] md:h-[380px] flex-shrink-0">
          {/* Outer ring - Skills */}
          <div className="absolute inset-0 rounded-full bg-[#e8ddd4] dark:bg-[#d4c4b5] flex items-start justify-center pt-6 sm:pt-8">
            <div className="text-center">
              <div className="text-base sm:text-lg md:text-xl font-semibold text-[#3d3530]">Skills</div>
              <div className="text-xs sm:text-sm text-[#5a504a]">applications</div>
            </div>
          </div>

          {/* Middle ring - Agent Harness */}
          <div className="absolute top-[22%] left-[15%] right-[15%] bottom-[8%] rounded-full bg-[#5cb88f] dark:bg-[#4da87f] flex items-start justify-center pt-5 sm:pt-8">
            <div className="text-center">
              <div className="text-base sm:text-lg md:text-xl font-semibold text-white">Agent Harness</div>
              <div className="text-xs sm:text-sm text-white/80">Operating Systems</div>
            </div>
          </div>

          {/* Inner circle - Models */}
          <div className="absolute top-[42%] left-[28%] right-[28%] bottom-[14%] rounded-full bg-[#d96c3c] dark:bg-[#e07040] flex items-center justify-center">
            <div className="text-center">
              <div className="text-base sm:text-lg md:text-xl font-semibold text-white">Models</div>
              <div className="text-xs sm:text-sm text-white/80">CPUs</div>
            </div>
          </div>
        </div>

        {/* Explanations */}
        <div className="flex flex-col gap-4 sm:gap-6 max-w-md">
          <div className="flex items-start gap-3 sm:gap-4">
            <div className="w-3 h-3 sm:w-4 sm:h-4 rounded-full bg-[#e8ddd4] dark:bg-[#d4c4b5] border border-[#c4b5a6] dark:border-[#b8a898] flex-shrink-0 mt-1 sm:mt-1.5"></div>
            <div>
              <h3 className="font-medium mb-0.5 sm:mb-1 text-sm sm:text-base">Skills Layer</h3>
              <p className="text-xs sm:text-sm text-muted">
                Domain-specific capabilities and workflows that extend agent functionality. Like applications on an OS, skills provide specialized knowledge and tools for particular tasks.
              </p>
            </div>
          </div>

          <div className="flex items-start gap-3 sm:gap-4">
            <div className="w-3 h-3 sm:w-4 sm:h-4 rounded-full bg-[#5cb88f] dark:bg-[#4da87f] flex-shrink-0 mt-1 sm:mt-1.5"></div>
            <div>
              <h3 className="font-medium mb-0.5 sm:mb-1 text-sm sm:text-base">Agent Harness Layer</h3>
              <p className="text-xs sm:text-sm text-muted">
                The execution environment that orchestrates agents, manages tool access, and handles I/O. Analogous to an operating system that mediates between applications and hardware.
              </p>
            </div>
          </div>

          <div className="flex items-start gap-3 sm:gap-4">
            <div className="w-3 h-3 sm:w-4 sm:h-4 rounded-full bg-[#d96c3c] dark:bg-[#e07040] flex-shrink-0 mt-1 sm:mt-1.5"></div>
            <div>
              <h3 className="font-medium mb-0.5 sm:mb-1 text-sm sm:text-base">Models Layer</h3>
              <p className="text-xs sm:text-sm text-muted">
                The foundational AI models that power reasoning and generation. Like CPUs, they provide the raw computational capability that upper layers build upon.
              </p>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
