"use client";

import { Button } from "@/components/ui/button";
import {
  Popover,
  PopoverContent,
  PopoverTrigger,
} from "@/components/ui/popover";
import { ArrowUpRight } from "lucide-react";
import Link from "next/link";

export function AgentSkillsExplainer() {
  return (
    <Popover>
      <PopoverTrigger asChild>
        <span className="cursor-pointer underline decoration-muted-foreground/30 hover:decoration-primary underline-offset-[6px] decoration-2 transition-[text-decoration-color]">
          Skills
        </span>
      </PopoverTrigger>
      <PopoverContent className="w-[380px] p-6 animate-popover" align="start">
        <div className="space-y-4">
          <div className="space-y-2">
            <h4 className="text-lg font-bold leading-none tracking-tight">
              Agent Skills
            </h4>
            <p className="text-base text-foreground/90 leading-relaxed">
              Agent Skills are folders of instructions, scripts, and resources
              that agents can discover and use to do things more accurately and
              efficiently.
            </p>
          </div>
          <Button
            asChild
            variant="outline"
            size="sm"
            className="w-full h-10 text-sm"
          >
            <Link href="https://agentskills.io/home" target="_blank">
              Read the spec
              <ArrowUpRight className="ml-2 h-3 w-3" />
            </Link>
          </Button>
        </div>
      </PopoverContent>
    </Popover>
  );
}
