import type { MetadataRoute } from "next";
import { source, blog } from "@/lib/source";
import { getTasks } from "@/utils/tasks";

const BASE_URL = "https://skillsbench.ai";

export default async function sitemap(): Promise<MetadataRoute.Sitemap> {
  const tasks = await getTasks();

  const staticRoutes: MetadataRoute.Sitemap = [
    { url: BASE_URL, lastModified: new Date(), changeFrequency: "weekly", priority: 1 },
    { url: `${BASE_URL}/leaderboard`, lastModified: new Date(), changeFrequency: "weekly", priority: 0.9 },
    { url: `${BASE_URL}/tasks`, lastModified: new Date(), changeFrequency: "weekly", priority: 0.8 },
    { url: `${BASE_URL}/skills`, lastModified: new Date(), changeFrequency: "weekly", priority: 0.8 },
    { url: `${BASE_URL}/blogs`, lastModified: new Date(), changeFrequency: "weekly", priority: 0.7 },
    { url: `${BASE_URL}/contributors`, lastModified: new Date(), changeFrequency: "monthly", priority: 0.5 },
    { url: `${BASE_URL}/docs`, lastModified: new Date(), changeFrequency: "monthly", priority: 0.7 },
  ];

  const taskRoutes: MetadataRoute.Sitemap = tasks.map((task) => ({
    url: `${BASE_URL}/tasks/${encodeURIComponent(task.title)}`,
    lastModified: new Date(task.updatedAt),
    changeFrequency: "monthly",
    priority: 0.6,
  }));

  const docPages = source.getPages().filter((p) => p.slugs.length > 0);
  const docRoutes: MetadataRoute.Sitemap = docPages.map((page) => ({
    url: `${BASE_URL}${page.url}`,
    lastModified: new Date(),
    changeFrequency: "monthly",
    priority: 0.6,
  }));

  const blogPages = blog.getPages();
  const blogRoutes: MetadataRoute.Sitemap = blogPages.map((page) => ({
    url: `${BASE_URL}${page.url}`,
    lastModified: new Date((page.data as any).date),
    changeFrequency: "monthly",
    priority: 0.7,
  }));

  return [...staticRoutes, ...taskRoutes, ...docRoutes, ...blogRoutes];
}
