import { RootProvider } from "fumadocs-ui/provider/next";
import type { Metadata } from "next";
import { Toaster } from "sonner";
import "./globals.css";
import { PostHogProvider } from "./posthog-provider";

export const metadata: Metadata = {
  metadataBase: new URL("https://skillsbench.ai"),
  title: {
    default: "SkillsBench — AI Agent Skills Benchmark & Evaluation",
    template: "%s | SkillsBench",
  },
  description:
    "SkillsBench is the first benchmark for evaluating AI agent skills. Measure how skills improve agent performance across 84 tasks, 7 models, and 3 agent harnesses. The leading skills eval and agent capability benchmark.",
  keywords: [
    "SkillsBench",
    "skills bench",
    "skill bench",
    "skills benchmark",
    "agent skills evaluation",
    "agent skills eval",
    "skill evals",
    "AI agent benchmark",
    "coding agent benchmark",
    "agent capability evaluation",
    "benchmarks for skills",
    "benchmarks for agent skills",
    "Claude Code benchmark",
    "Codex CLI benchmark",
    "Gemini CLI benchmark",
    "AI agent leaderboard",
  ],
  icons: {
    icon: "/favicon.svg",
  },
  openGraph: {
    title: "SkillsBench — AI Agent Skills Benchmark & Evaluation",
    description:
      "The first benchmark for evaluating AI agent skills. 84 tasks, 7 models, 5 trials per task. See how skills improve agent performance across diverse domains.",
    siteName: "SkillsBench",
    type: "website",
    url: "https://skillsbench.ai",
  },
  twitter: {
    card: "summary_large_image",
    title: "SkillsBench — AI Agent Skills Benchmark",
    description:
      "The first benchmark for evaluating AI agent skills. 84 tasks, 7 models, 5 trials per task. See how skills improve agent performance across diverse domains.",
  },
  alternates: {
    canonical: "https://skillsbench.ai",
  },
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en" suppressHydrationWarning className="font-satoshi">
      <head>
        <link
          href="https://api.fontshare.com/v2/css?f[]=satoshi@300,400,500,700,900&display=swap"
          rel="stylesheet"
        />
      </head>
      <body className="antialiased">
        <PostHogProvider>
          <RootProvider
            theme={{
              attribute: "class",
              defaultTheme: "system",
              enableSystem: true,
            }}
          >
            {children}
          </RootProvider>
          <Toaster />
        </PostHogProvider>
      </body>
    </html>
  );
}
