import { source } from "@/lib/source";
import { PageLayout } from "@/components/PageLayout";
import {
  Card,
  CardDescription,
  CardHeader,
  CardTitle,
} from "@/components/ui/card";
import { ArrowRight, BookOpen } from "lucide-react";
import type { Metadata } from "next";
import Link from "next/link";

export const metadata: Metadata = {
  title: "Documentation",
  description:
    "Learn how to contribute tasks to SkillsBench, set up your environment, and evaluate AI agents with the skills benchmark framework.",
  alternates: { canonical: "https://skillsbench.ai/docs" },
};

const PAGE_ORDER = ["getting-started", "contributing"];

export default function DocsIndexPage() {
  const pages = source
    .getPages()
    .filter((p) => p.slugs.length > 0)
    .sort((a, b) => {
      const ai = PAGE_ORDER.indexOf(a.slugs[0]);
      const bi = PAGE_ORDER.indexOf(b.slugs[0]);
      return (ai === -1 ? Infinity : ai) - (bi === -1 ? Infinity : bi);
    });

  return (
    <PageLayout
      title="Documentation"
      description="Learn about SkillsBench — what it is, how to contribute, and how to create tasks."
      icon={null}
    >
      <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
        {pages.map((page) => {
          const data = page.data as any;
          return (
            <Card
              key={page.url}
              className="group hover:border-primary/50 transition-colors"
            >
              <Link href={page.url} className="block h-full">
                <CardHeader className="p-5">
                  <CardTitle className="text-lg font-semibold tracking-tight group-hover:text-primary transition-colors">
                    {data.title}
                  </CardTitle>
                  {data.description && (
                    <CardDescription className="text-sm line-clamp-2 mt-1">
                      {data.description}
                    </CardDescription>
                  )}
                  <div className="pt-3 flex items-center text-primary font-medium text-sm opacity-0 group-hover:opacity-100 transition-opacity">
                    Read <ArrowRight className="ml-1 w-3.5 h-3.5" />
                  </div>
                </CardHeader>
              </Link>
            </Card>
          );
        })}
      </div>
    </PageLayout>
  );
}
