"use server";

import { getPaginatedSkills, Skill } from "@/utils/skills";

export async function fetchSkills(page: number, limit: number = 10, query?: string): Promise<{ skills: Skill[]; hasMore: boolean }> {
  try {
    return await getPaginatedSkills(page, limit, query);
  } catch (error) {
    console.error("Failed to fetch skills:", error);
    return { skills: [], hasMore: false };
  }
}
