import { SkillsWaterfall } from "@/components/SkillsWaterfall";
import { PageLayout } from "@/components/PageLayout";
import { getAllSkills } from "@/utils/skills";
import type { Metadata } from "next";

export const metadata: Metadata = {
  title: "Skills",
  description:
    "Explore the agent skills evaluated in SkillsBench. Each skill represents a domain-specific capability — from office suite automation to git workflows — that extends AI agent functionality.",
  alternates: { canonical: "https://skillsbench.ai/skills" },
};

export default async function SkillsPage() {
  const skills = await getAllSkills();

  return (
    <PageLayout
      title="Skills"
      description="Explore the specialized capabilities (skills) integrated into the project. Each skill represents a distinct domain of expertise."
      icon={null}
    >
      <SkillsWaterfall skills={skills} />
    </PageLayout>
  );
}
