import { PageLayout } from "@/components/PageLayout";
import { blog } from "@/lib/source";
import { NewsCard } from "./components/news-card";
import { Tweet } from "react-tweet";
import type { Metadata } from "next";

export const metadata: Metadata = {
  title: "News & Blogs",
  description:
    "Latest updates, announcements, and research insights from the SkillsBench team on AI agent skills evaluation and benchmarking.",
  alternates: { canonical: "https://skillsbench.ai/blogs" },
};

const launches = [
  {
    id: "2010805530546356285",
    title: "SkillsBench Launch",
  },
  {
    id: "2008106947317506500",
    title: "Week 1 Update",
  },
];

export default function BlogPage() {
  const posts = blog.getPages();

  return (
    <PageLayout
      title="Blogs"
      description="Latest updates, announcements, and insights from the SkillsBench team."
      icon={null}
    >
      <div className="grid grid-cols-1 gap-6">
        {posts
          .sort(
            (a, b) =>
              new Date((b.data as any).date).getTime() -
              new Date((a.data as any).date).getTime(),
          )
          .map((post) => {
            const data = post.data as any;
            return (
              <NewsCard
                key={post.url}
                url={post.url}
                date={data.date}
                category={data.category}
                title={data.title}
                description={data.description}
              />
            );
          })}
      </div>

      {/* Launches subsection */}
      <div className="mt-16">
        <h2 className="text-xl font-bold mb-6">Launches</h2>
        <p className="text-muted-foreground text-sm mb-8">
          Follow our journey building SkillsBench.
        </p>
        <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
          {launches.map((launch) => (
            <div key={launch.id} className="tweet-column">
              <Tweet id={launch.id} />
            </div>
          ))}
        </div>
      </div>
    </PageLayout>
  );
}
