import { Badge } from "@/components/ui/badge";
import {
  Card,
  CardDescription,
  CardHeader,
  CardTitle,
} from "@/components/ui/card";
import { ArrowRight, Calendar } from "lucide-react";
import Link from "next/link";

interface NewsCardProps {
  url: string;
  date: string | Date;
  category: string | undefined;
  title: string;
  description?: string;
}

export function NewsCard({
  url,
  date,
  category,
  title,
  description,
}: NewsCardProps) {
  return (
    <Card className="group hover:border-primary/50 transition-colors overflow-hidden">
      <Link href={url} className="block h-full">
        <CardHeader className="p-5">
          <div className="mb-4 flex items-center justify-between gap-2">
            <div className="flex items-center gap-2 text-sm text-muted-foreground">
              <Calendar className="w-4 h-4" />
              <time dateTime={new Date(date).toISOString()}>
                {new Date(date).toLocaleDateString("en-US", {
                  year: "numeric",
                  month: "long",
                  day: "numeric",
                })}
              </time>
            </div>
            {category && (
              <Badge variant="secondary" className="font-medium">
                {category}
              </Badge>
            )}
          </div>

          <div className="space-y-3">
            <CardTitle className="text-2xl font-bold tracking-tight group-hover:text-primary transition-colors">
              {title}
            </CardTitle>
            {description && (
              <CardDescription className="text-base line-clamp-2">
                {description}
              </CardDescription>
            )}
          </div>

          <div className="pt-4 flex items-center text-primary font-medium text-sm group-hover:translate-x-1 transition-transform">
            Read more <ArrowRight className="ml-1 w-4 h-4" />
          </div>
        </CardHeader>
      </Link>
    </Card>
  );
}
