import { defineDocs, defineConfig, defineCollections, frontmatterSchema } from 'fumadocs-mdx/config';
import { z } from 'zod';

export const { docs, meta } = defineDocs({
  dir: 'src/content/docs',
});

export const blog = defineCollections({
  type: 'doc',
  dir: 'src/content/news',
  schema: frontmatterSchema.extend({
    authors: z.array(
      z.object({
        name: z.string(),
        url: z.string().url().optional(),
      }),
    ),
    date: z.string().date().or(z.date()),
    category: z.string().optional().default("Release"),
    hideToc: z.boolean().optional().default(false),
  }),
});

export default defineConfig();
