# Agent Guidelines: skills-bench website

## Project Overview

This is a Next.js (App Router) website for the SkillsBench project. It displays benchmark tasks, contributors, and launches.

## Tech Stack

- Framework: Next.js 16 (App Router)
- Styling: Tailwind CSS 4 with PostCSS
- Language: TypeScript
- UI Components: Custom React components using Tailwind
- Data Fetching: GitHub API integration

## Commands

- Development: `bun dev`
- Build: `bun run build`
- Deploy (Vercel): `vercel --prod`
- Lint: `bun lint`
- Type Check: `bunx tsc --noEmit`

## Code Style & Conventions

### 1. Imports

- Use absolute paths with the `@/` alias (e.g., `import { Navbar } from "@/components/Navbar"`).

### 2. Components

- Use Functional Components with named exports.
- Prefer `export function ComponentName() { ... }` over default exports.
- Use `"use client";` directive at the top of files that use browser-only APIs or hooks (state, effects).
- Place components in `src/components/` for shared UI, and `src/app/` for page-specific layouts.

### 3. Styling

- Use Tailwind CSS utility classes exclusively.
- Use standard theme colors (e.g., `text-muted-foreground`, `text-foreground`, `bg-background`, `border-border`).
- Follow the existing design pattern: clean, modern, with dark/light mode support using `next-themes`.
- **Do not use shadows** (e.g., avoid `shadow-sm`, `shadow-lg`, `drop-shadow`). Use borders or subtle background color differences for separation instead.

### 4. Data Fetching

- Prefer Server Components for data fetching where possible.
- Use the `fetch` API with Next.js caching options (`next: { revalidate: ... }`).
- Handle errors gracefully with try-catch blocks and provide fallback UI or log errors to console.

## Deployment

### Production Deployment (skillsbench.ai)

The project is deployed to **skillsbench.ai** via Vercel using **Bun**.

**Key Configuration for Production:**
1. **Package Manager**: Bun is the primary package manager. `package-lock.json` is removed to avoid conflicts.
2. **Task Data**: Full task data (~500MB) is outside the web root. We use `src/data/tasks-registry.json` (pre-generated locally via `bun run generate-tasks`) to provide all task metadata and instructions at build time.
3. **Registry Script**: `scripts/generate-tasks-registry.ts` is configured to gracefully handle missing raw task files during Vercel's build process.

**To Redeploy:**
```bash
vercel --prod
```
