package com.example.userservice.config;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

/**
 * Component for custom security expressions used in @PreAuthorize annotations.
 */
@Component("userSecurity")
public class UserSecurity {

    /**
     * Check if the current authenticated user is the owner of the resource.
     * This is used in @PreAuthorize expressions like @userSecurity.isOwner(#id)
     */
    public boolean isOwner(Long userId) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            return false;
        }

        // Get the username from the authentication principal
        String currentUsername = authentication.getName();

        // In a real application, you would check if the userId belongs to the current user
        // For simplicity, we're checking if the authentication name matches a user ID pattern
        // This should be replaced with actual user ID lookup logic
        return currentUsername != null && currentUsername.equals(userId.toString());
    }
}
