Solve travelling purchase problem (TPP) tasks using PDDL (Planning Domain Definition Language).

Each task has two input files: a PDDL domain file and a PDDL problem file. As a planning agent, you may need both of them. The domain and problem file paths for each task are specified the "domain" key and "problem" key in the `problem.json` file. An example task entry looks like below:

```json
[
  {
  "id": "problem_id",
  "domain": ".../xxx.pddl",
  "problem": ".../yyy.pddl",
  "plan_output": "xxx/problem_id.txt"
  },
  ...,
]
```

For each task specified in `problem.json`, you need to: First, load the PDDL domain file and PDDL problem file. Second, generate a PDDL plan for solving the planning problem. Finally, write the generated plan to the path specified by “plan_output”. An example PDDL plan looks like:

```
drive(truck1, depot1, market1)
buy(truck1, goods1, market1, level0, level1, level0, level1)
load(goods1, truck1, market1, level0, level1, level0, level1)
drive(truck1, market1, depot1)
unload(goods1, truck1, depot1, level0, level1, level0, level1)
```

Note that

- The plan should be a syntactically correct PDDL plan.
- The plan should be valid, it should solve the problem when executed according to the PDDL grammar.
- Each action primitive should be written on a line.
- Action names and object names in the generated plan should match the PDDL domain and PDDL problem.

---

## Important: Generate Skills First

Before attempting to solve this task, please follow these steps:

1. **Analyze the task requirements** and identify what domain knowledge, APIs, or techniques are needed.

2. **Write 1-5 modular skill documents** that would help solve this task. Each skill should:
   - Focus on a specific tool, library, API, or technique
   - Include installation/setup instructions if applicable
   - Provide code examples and usage patterns
   - Be reusable for similar tasks

3. **Save each skill** as a markdown file in the `environment/skills/` directory with a descriptive name (e.g., `pandas-dataframe.md`, `opencv-image-processing.md`).

4. **Then solve the task** using the skills you created as reference.

This approach tests your ability to identify and document relevant knowledge before applying it.
