---
name: energy-calculator
description: Calculate per-second RMS energy from audio files. Use when you need to analyze audio volume patterns, prepare data for silence/pause detection, or create an energy profile for audio analysis tasks.
---

# Energy Calculator

Calculates per-second RMS (Root Mean Square) energy from audio files. Produces an energy profile that can be used for opening detection, pause detection, or other audio analysis tasks.

## Use Cases

- Calculating audio energy for silence detection
- Preparing data for opening/pause detection
- Analyzing audio volume patterns

## Usage

```bash
python3 /root/.claude/skills/energy-calculator/scripts/calc_energy.py \
    --audio /path/to/audio.wav \
    --output /path/to/energies.json
```

### Parameters

- `--audio`: Path to input WAV file
- `--output`: Path to output JSON file
- `--window-seconds`: Window size for energy calculation (default: 1 second)

### Output Format

```json
{
  "sample_rate": 16000,
  "window_seconds": 1,
  "total_seconds": 600,
  "energies": [123.5, 456.7, 234.2, ...],
  "stats": {
    "min": 45.2,
    "max": 892.3,
    "mean": 234.5,
    "std": 156.7
  }
}
```

## How It Works

1. Load audio file
2. Split into 1-second windows
3. Calculate RMS energy for each window: `sqrt(mean(samples^2))`
4. Output array of energy values

## Dependencies

- Python 3.11+
- numpy

## Example

```bash
# Calculate energy from extracted audio
python3 /root/.claude/skills/energy-calculator/scripts/calc_energy.py \
    --audio audio.wav \
    --output energies.json
```

## Notes

- RMS energy correlates with perceived loudness
- Higher values = louder audio, lower values = quieter/silence
- Output can be used by opening-detector and pause-detector skills
