---
name: audio-extractor
description: Extract audio from video files to WAV format. Use when you need to analyze audio from video, prepare audio for energy calculation, or convert video audio to standard format for processing.
---

# Audio Extractor

Extracts audio from video files to WAV format for further analysis. Converts to mono 16kHz PCM format optimized for speech/energy analysis.

## Use Cases

- Extracting audio for speech analysis
- Preparing audio for energy calculation
- Converting video audio to standard format

## Usage

```bash
python3 /root/.claude/skills/audio-extractor/scripts/extract_audio.py \
    --video /path/to/video.mp4 \
    --output /path/to/audio.wav
```

### Parameters

- `--video`: Path to input video file
- `--output`: Path to output WAV file
- `--sample-rate`: Audio sample rate in Hz (default: 16000)
- `--duration`: Optional duration limit in seconds (default: full video)

### Output Format

- Format: WAV (PCM 16-bit signed)
- Channels: Mono
- Sample rate: 16000 Hz (default)

## Dependencies

- ffmpeg

## Example

```bash
# Extract first 10 minutes of audio
python3 /root/.claude/skills/audio-extractor/scripts/extract_audio.py \
    --video lecture.mp4 \
    --duration 600 \
    --output audio.wav
```

## Notes

- Output is always mono for consistent analysis
- 16kHz sample rate is sufficient for speech analysis and reduces file size
- Supports any video format that ffmpeg can read
