# Google Cloud OAuth Setup Guide

Complete guide to setting up Google Cloud credentials for Google Calendar API access.

## Prerequisites

- Google account
- Web browser
- Terminal access

## Step-by-Step Setup

### 1. Create Google Cloud Project

1. Go to [Google Cloud Console](https://console.cloud.google.com/)
2. Sign in with your Google account
3. Click the project dropdown at the top
4. Click **"New Project"**
5. Enter project name (e.g., "Claude Calendar Integration")
6. Click **"Create"**
7. Wait for project creation (you'll see a notification)
8. Select your new project from the dropdown

### 2. Enable Google Calendar API

1. In the Google Cloud Console, click the hamburger menu (☰)
2. Navigate to **"APIs & Services"** → **"Library"**
3. Search for **"Google Calendar API"**
4. Click on **"Google Calendar API"**
5. Click the **"Enable"** button
6. Wait for API to be enabled

### 3. Configure OAuth Consent Screen

1. In the left sidebar, click **"OAuth consent screen"**
2. Select **"External"** user type
3. Click **"Create"**

**Fill in App Information:**
- App name: `Claude Calendar Skill` (or your preferred name)
- User support email: Your email address
- Developer contact email: Your email address

4. Click **"Save and Continue"**

**Scopes:**
5. Click **"Add or Remove Scopes"**
6. Search for `calendar` in the filter
7. Select: **`https://www.googleapis.com/auth/calendar`**
   - This scope allows full read/write access to calendars and events
8. Click **"Update"**
9. Click **"Save and Continue"**

**Test Users:**
10. Click **"Add Users"**
11. Add your Google account email address
12. Click **"Add"**
13. Click **"Save and Continue"**

**Summary:**
14. Review the information
15. Click **"Back to Dashboard"**

### 4. Create OAuth Credentials

1. In the left sidebar, click **"Credentials"**
2. Click **"+ Create Credentials"** at the top
3. Select **"OAuth client ID"**

**Configure OAuth Client:**
4. Application type: Select **"Desktop app"**
5. Name: `Claude Calendar Client` (or your preferred name)
6. Click **"Create"**

**Download Credentials:**
7. A dialog will appear with your Client ID and Secret
8. Click **"Download JSON"**
9. Save the file as `credentials.json`

### 5. Save Credentials to Skill

1. Move the downloaded file to the skill's auth directory:

```bash
mv ~/Downloads/credentials.json ~/.claude/skills/google-calendar-skill/scripts/auth/credentials.json
```

2. Verify the file is in the correct location:

```bash
ls -la ~/.claude/skills/google-calendar-skill/scripts/auth/credentials.json
```

You should see the file listed.

### 6. Install Dependencies

```bash
cd ~/.claude/skills/google-calendar-skill
npm install
```

### 7. Run OAuth Setup

```bash
npm run setup
```

This will:
1. Open your browser automatically
2. Ask you to sign in to Google
3. Show a consent screen asking for Calendar permissions
4. Redirect to localhost (you'll see a success message)
5. Save the OAuth token to `scripts/auth/token.json`

**Important Security Notes:**
- Click **"Continue"** when you see the "App isn't verified" warning (this is expected for personal projects)
- Review the permissions carefully - you're granting access to your Google Calendar
- The token is stored locally on your machine only

### 8. Verify Setup

Test that everything works:

```bash
cd ~/.claude/skills/google-calendar-skill/scripts
node calendar-list.js
```

You should see JSON output with your calendars.

Test listing events:

```bash
node calendar-events-list.js --limit 5
```

You should see JSON output with upcoming calendar events.

## Troubleshooting

### "App isn't verified" Warning

**Problem:** Google shows a warning that the app isn't verified.

**Solution:** This is normal for personal projects. Click **"Advanced"** → **"Go to [App Name] (unsafe)"** → **"Continue"**.

### "Access blocked: This app's request is invalid"

**Problem:** OAuth consent screen not configured correctly.

**Solution:**
1. Go to OAuth consent screen
2. Ensure you added your email as a test user
3. Ensure Google Calendar API scope is added
4. Try authentication again

### "Token not found" Error

**Problem:** OAuth setup didn't complete successfully.

**Solution:**
1. Check that `credentials.json` exists in `scripts/auth/`
2. Run `npm run setup` again
3. Complete the browser authentication flow
4. Verify `token.json` was created in `scripts/auth/`

### "The user has not granted the app" Error

**Problem:** Calendar API scope wasn't granted during OAuth flow.

**Solution:**
1. Delete `scripts/auth/token.json`
2. Run `npm run setup` again
3. Carefully review permissions and click **"Allow"**

### "Invalid client" Error

**Problem:** `credentials.json` is corrupted or incorrect.

**Solution:**
1. Go back to Google Cloud Console
2. Download credentials again
3. Replace `scripts/auth/credentials.json`
4. Run `npm run setup` again

### "Calendar API has not been used" Error

**Problem:** Calendar API is not enabled for your project.

**Solution:**
1. Go to Google Cloud Console
2. Navigate to APIs & Services → Library
3. Search for "Google Calendar API"
4. Click "Enable"
5. Try authentication again

## Security Best Practices

1. **Never commit credentials:**
   - `credentials.json` and `token.json` should never be shared
   - Add them to `.gitignore` if using version control

2. **Token refresh:**
   - Tokens are long-lived but may expire
   - Refresh by running `npm run setup` again if needed

3. **Revoke access:**
   - Go to [Google Account Security](https://myaccount.google.com/permissions)
   - Find your app and click **"Remove Access"**

4. **Scope explanation:**
   - The skill uses `calendar` scope (full read/write access)
   - This allows creating, updating, and deleting calendar events
   - This is the minimum scope needed for full functionality

## Additional Resources

- [Google Calendar API Documentation](https://developers.google.com/calendar/api)
- [OAuth 2.0 for Desktop Apps](https://developers.google.com/identity/protocols/oauth2/native-app)
- [Calendar API Scopes](https://developers.google.com/calendar/api/auth)

## Next Steps

Once setup is complete:
1. Read the main `README.md` for usage examples
2. Try listing your calendars and events
3. Create a test event
4. Explore search and update functionality

The skill is now ready to use with Claude Code!
