# Core Concepts

## Standard vs Hyper-Connections

Standard residual connection:
```
x_{l+1} = x_l + F(x_l)
```

Hyper-Connections with multiple streams:
```
x_{l+1} = H_res @ x_l + H_post.T @ F(H_pre @ x_l)
```

Where:
- `x_l` has shape `(batch, seq, num_streams, dim)`
- `H_res` is `(num_streams, num_streams)` - mixes residual streams (width connection)
- `H_pre` is `(1, num_streams)` - selects which streams feed the branch
- `H_post` is `(1, num_streams)` - distributes branch output to streams (depth connection)

## The mHC Constraint

The key insight: vanilla Hyper-Connections are unstable because `H_res` can drift away from identity-like behavior. mHC fixes this by constraining `H_res` to be **doubly stochastic**.

A doubly stochastic matrix:
- Has all non-negative entries
- Each row sums to 1
- Each column sums to 1

This keeps `H_res` within the Birkhoff polytope, preserving signal magnitude.

## Why Doubly Stochastic?

1. **Preserves scale**: The sum of outputs equals the sum of inputs
2. **Bounded eigenvalues**: All eigenvalues have magnitude ≤ 1
3. **Interpolates identity and permutation**: Identity matrix is doubly stochastic, as are all permutation matrices
4. **Convex set**: The set of doubly stochastic matrices (Birkhoff polytope) is convex, enabling stable optimization

## Tensor Shapes

Throughout mHC, tensors follow this shape convention:

| Tensor | Shape | Description |
|--------|-------|-------------|
| Input x | `(batch * num_streams, seq, dim)` | Flattened for efficient processing |
| Reshaped x | `(batch, seq, num_streams, dim)` | For stream mixing |
| H_res | `(num_streams, num_streams)` | Width mixing matrix |
| H_pre | `(1, num_streams)` | Branch input selection |
| H_post | `(1, num_streams)` | Branch output distribution |
