---
name: xlsx
description: "Spreadsheet creation, editing, and validation skill. Use when working with Excel files (.xlsx/.xlsm/.csv) to read source data, build structured outputs, keep formulas dynamic, and avoid spreadsheet formula errors."
---

# XLSX Workflow Guide

## Core requirements

- Prefer spreadsheet-native formulas for calculated fields.
- Keep existing template structure unless the prompt asks for a redesign.
- Avoid formula errors (`#REF!`, `#DIV/0!`, `#VALUE!`, `#N/A`, `#NAME?`).

## Recommended workflow

1. Inspect workbook structure and required tabs.
2. Fill raw inputs first.
3. Add formulas using cell references (not hardcoded computed values).
4. Save workbook.
5. Recalculate formulas when needed:

```bash
python /root/.claude/skills/xlsx/recalc.py <excel_file> [timeout_seconds]
```

## Formula conventions

- Use explicit references instead of embedded constants when possible.
- Handle divide-by-zero explicitly (for example with `IF` wrappers).
- Keep scenario assumptions in separate cells.

## Common guardrails

- Do not open workbook with `data_only=True` and then save (it destroys formulas).
- Verify cross-sheet references point to valid sheet names.
- For large sheets, test a few sample formulas before applying widely.
