#!/bin/bash
# Script to get the most recent timestamp from an asciinema recording.
#
# Usage:
#     ./get-asciinema-timestamp.sh <recording_path>

# Check if a recording path was provided
if [ $# -ne 1 ]; then
    echo "Usage: ./get-asciinema-timestamp.sh <recording_path>"
    exit 1
fi

recording_path="$1"

# Check if the file exists
if [ ! -f "$recording_path" ]; then
    echo "Error: File '$recording_path' does not exist."
    exit 1
fi

# Extract the last timestamp from the recording file
# This uses grep to find lines starting with '[' and containing a timestamp
# Then uses tail to get the last one, and sed to extract just the timestamp
last_timestamp=$(grep -E '^\[[0-9]+\.[0-9]+,' "$recording_path" | tail -n 1 | sed -E 's/^\[([0-9]+\.[0-9]+),.*/\1/')

# If no timestamp was found, use 0.0
if [ -z "$last_timestamp" ]; then
    last_timestamp="0.0"
fi

# Print the timestamp to stdout
echo "$last_timestamp"
