/*
 * Decompiled with CFR 0.152.
 */
package jp.kshoji.javax.sound.midi.io;

import androidx.annotation.NonNull;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jp.kshoji.javax.sound.midi.MetaMessage;
import jp.kshoji.javax.sound.midi.MidiEvent;
import jp.kshoji.javax.sound.midi.Sequence;
import jp.kshoji.javax.sound.midi.Track;
import jp.kshoji.javax.sound.midi.spi.MidiFileWriter;

public class StandardMidiFileWriter
extends MidiFileWriter {
    @Override
    @NonNull
    public int[] getMidiFileTypes() {
        return new int[]{0, 1};
    }

    @Override
    @NonNull
    public int[] getMidiFileTypes(@NonNull Sequence sequence) {
        if (sequence.getTracks().length > 1) {
            return new int[]{1};
        }
        return new int[]{0, 1};
    }

    @Override
    public int write(@NonNull Sequence sequence, int fileType, @NonNull File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        int written = this.write(sequence, fileType, fileOutputStream);
        fileOutputStream.close();
        return written;
    }

    @Override
    public int write(@NonNull Sequence sequence, int fileType, @NonNull OutputStream outputStream) throws IOException {
        MidiDataOutputStream midiDataOutputStream = new MidiDataOutputStream(outputStream);
        Track[] tracks = sequence.getTracks();
        midiDataOutputStream.writeInt(1297377380);
        midiDataOutputStream.writeInt(6);
        midiDataOutputStream.writeShort(fileType);
        midiDataOutputStream.writeShort(tracks.length);
        float divisionType = sequence.getDivisionType();
        int resolution = sequence.getResolution();
        int division = 0;
        if (divisionType == 0.0f) {
            division = resolution & Short.MAX_VALUE;
        } else if (divisionType == 24.0f) {
            division = -6144;
            division += resolution & 0xFF;
        } else if (divisionType == 25.0f) {
            division = -6400;
            division += resolution & 0xFF;
        } else if (divisionType == 29.97f) {
            division = -7424;
            division += resolution & 0xFF;
        } else if (divisionType == 30.0f) {
            division = -7680;
            division += resolution & 0xFF;
        }
        midiDataOutputStream.writeShort(division);
        int length = 0;
        for (Track track : tracks) {
            length += StandardMidiFileWriter.writeTrack(track, midiDataOutputStream);
        }
        midiDataOutputStream.close();
        return length + 14;
    }

    private static int writeTrack(@NonNull Track track, @NonNull MidiDataOutputStream midiDataOutputStream) throws IOException {
        int eventCount = track.size();
        midiDataOutputStream.writeInt(1297379947);
        int trackLength = 0;
        long lastTick = 0L;
        MidiEvent midiEvent = null;
        for (int i = 0; i < eventCount; ++i) {
            midiEvent = track.get(i);
            long tick = midiEvent.getTick();
            trackLength += MidiDataOutputStream.variableLengthIntLength((int)(tick - lastTick));
            lastTick = tick;
            trackLength += midiEvent.getMessage().getLength();
        }
        boolean needEndOfTrack = true;
        if (midiEvent != null && midiEvent.getMessage() instanceof MetaMessage && ((MetaMessage)midiEvent.getMessage()).getType() == 47) {
            needEndOfTrack = false;
        } else {
            trackLength += 4;
        }
        midiDataOutputStream.writeInt(trackLength);
        lastTick = 0L;
        for (int i = 0; i < eventCount; ++i) {
            midiEvent = track.get(i);
            long tick = midiEvent.getTick();
            midiDataOutputStream.writeVariableLengthInt((int)(tick - lastTick));
            lastTick = tick;
            midiDataOutputStream.write(midiEvent.getMessage().getMessage(), 0, midiEvent.getMessage().getLength());
        }
        if (needEndOfTrack) {
            midiDataOutputStream.writeVariableLengthInt(0);
            midiDataOutputStream.writeByte(255);
            midiDataOutputStream.writeByte(47);
            midiDataOutputStream.writeVariableLengthInt(0);
        }
        return trackLength + 4;
    }

    private static class MidiDataOutputStream
    extends DataOutputStream {
        public MidiDataOutputStream(@NonNull OutputStream outputStream) {
            super(outputStream);
        }

        private static int getValueToWrite(int value) {
            int result = value & 0x7F;
            int currentValue = value;
            while ((currentValue >>= 7) != 0) {
                result <<= 8;
                result |= currentValue & 0x7F | 0x80;
            }
            return result;
        }

        private static int variableLengthIntLength(int value) {
            int valueToWrite = MidiDataOutputStream.getValueToWrite(value);
            int length = 0;
            while (true) {
                ++length;
                if ((valueToWrite & 0x80) == 0) break;
                valueToWrite >>>= 8;
            }
            return length;
        }

        private void writeVariableLengthInt(int value) throws IOException {
            int valueToWrite = MidiDataOutputStream.getValueToWrite(value);
            while (true) {
                this.writeByte(valueToWrite & 0xFF);
                if ((valueToWrite & 0x80) == 0) break;
                valueToWrite >>>= 8;
            }
        }
    }
}

