/*
 * Decompiled with CFR 0.152.
 */
package jp.kshoji.javax.sound.midi.impl;

import android.util.SparseArray;
import android.util.SparseBooleanArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.kshoji.javax.sound.midi.ControllerEventListener;
import jp.kshoji.javax.sound.midi.InvalidMidiDataException;
import jp.kshoji.javax.sound.midi.MetaEventListener;
import jp.kshoji.javax.sound.midi.MetaMessage;
import jp.kshoji.javax.sound.midi.MidiDevice;
import jp.kshoji.javax.sound.midi.MidiEvent;
import jp.kshoji.javax.sound.midi.MidiMessage;
import jp.kshoji.javax.sound.midi.MidiSystem;
import jp.kshoji.javax.sound.midi.MidiUnavailableException;
import jp.kshoji.javax.sound.midi.Receiver;
import jp.kshoji.javax.sound.midi.Sequence;
import jp.kshoji.javax.sound.midi.Sequencer;
import jp.kshoji.javax.sound.midi.ShortMessage;
import jp.kshoji.javax.sound.midi.SysexMessage;
import jp.kshoji.javax.sound.midi.Track;
import jp.kshoji.javax.sound.midi.Transmitter;
import jp.kshoji.javax.sound.midi.io.StandardMidiFileReader;

public class SequencerImpl
implements Sequencer {
    private static final Sequencer.SyncMode[] MASTER_SYNC_MODES = new Sequencer.SyncMode[]{Sequencer.SyncMode.INTERNAL_CLOCK};
    private static final Sequencer.SyncMode[] SLAVE_SYNC_MODES = new Sequencer.SyncMode[]{Sequencer.SyncMode.NO_SYNC};
    private final List<Transmitter> transmitters = new ArrayList<Transmitter>();
    private final List<Receiver> receivers = new ArrayList<Receiver>();
    private final Set<MetaEventListener> metaEventListeners = new HashSet<MetaEventListener>();
    private final SparseArray<Set<ControllerEventListener>> controllerEventListenerMap = new SparseArray();
    private final Map<Track, Set<Integer>> recordEnable = new HashMap<Track, Set<Integer>>();
    @Nullable
    private SequencerThread sequencerThread = null;
    private Sequence sequence = null;
    private volatile boolean isOpen = false;
    private int loopCount = 0;
    private long loopStartPoint = 0L;
    private long loopEndPoint = -1L;
    private volatile float tempoFactor = 1.0f;
    private Sequencer.SyncMode masterSyncMode = Sequencer.SyncMode.INTERNAL_CLOCK;
    private Sequencer.SyncMode slaveSyncMode = Sequencer.SyncMode.NO_SYNC;
    private final SparseBooleanArray trackMute = new SparseBooleanArray();
    private final SparseBooleanArray trackSolo = new SparseBooleanArray();
    private float tempoInBPM = 120.0f;
    private volatile boolean isRunning = false;
    private volatile boolean isRecording = false;

    @Override
    @NonNull
    public MidiDevice.Info getDeviceInfo() {
        return new MidiDevice.Info("Sequencer", "jp.kshoji", "Android MIDI Sequencer", "0.1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws MidiUnavailableException {
        Object object = this.receivers;
        synchronized (object) {
            this.receivers.clear();
            this.receivers.addAll(MidiSystem.MidiSystemUtils.getReceivers());
        }
        object = this.transmitters;
        synchronized (object) {
            this.transmitters.clear();
            this.transmitters.addAll(MidiSystem.MidiSystemUtils.getTransmitters());
        }
        if (this.sequencerThread == null) {
            this.sequencerThread = new SequencerThread();
            this.sequencerThread.setName("MidiSequencer_" + this.sequencerThread.getId());
            try {
                this.sequencerThread.start();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
        this.isOpen = true;
        object = this.sequencerThread;
        synchronized (object) {
            this.sequencerThread.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Collection<Object> collection = this.receivers;
        synchronized (collection) {
            this.receivers.clear();
        }
        collection = this.transmitters;
        synchronized (collection) {
            this.transmitters.clear();
        }
        if (this.sequencerThread != null) {
            this.sequencerThread.stopPlaying();
            this.sequencerThread.stopRecording();
            this.isOpen = false;
            this.sequencerThread = null;
        }
        collection = this.metaEventListeners;
        synchronized (collection) {
            this.metaEventListeners.clear();
        }
        collection = this.controllerEventListenerMap;
        synchronized (collection) {
            this.controllerEventListenerMap.clear();
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxReceivers() {
        List<Receiver> list = this.receivers;
        synchronized (list) {
            return this.receivers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxTransmitters() {
        List<Transmitter> list = this.transmitters;
        synchronized (list) {
            return this.transmitters.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Receiver getReceiver() throws MidiUnavailableException {
        List<Receiver> list = this.receivers;
        synchronized (list) {
            if (this.receivers.isEmpty()) {
                throw new MidiUnavailableException("Receiver not found");
            }
            return this.receivers.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public List<Receiver> getReceivers() {
        List<Receiver> list = this.receivers;
        synchronized (list) {
            return Collections.unmodifiableList(this.receivers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Transmitter getTransmitter() throws MidiUnavailableException {
        List<Transmitter> list = this.transmitters;
        synchronized (list) {
            if (this.transmitters.isEmpty()) {
                throw new MidiUnavailableException("Transmitter not found");
            }
            return this.transmitters.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public List<Transmitter> getTransmitters() {
        List<Transmitter> list = this.transmitters;
        synchronized (list) {
            return Collections.unmodifiableList(this.transmitters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public int[] addControllerEventListener(@NonNull ControllerEventListener listener, @NonNull int[] controllers) {
        SparseArray<Set<ControllerEventListener>> sparseArray = this.controllerEventListenerMap;
        synchronized (sparseArray) {
            for (int controllerId : controllers) {
                HashSet<ControllerEventListener> listeners = (HashSet<ControllerEventListener>)this.controllerEventListenerMap.get(controllerId);
                if (listeners == null) {
                    listeners = new HashSet<ControllerEventListener>();
                }
                listeners.add(listener);
                this.controllerEventListenerMap.put(controllerId, listeners);
            }
            return controllers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public int[] removeControllerEventListener(@NonNull ControllerEventListener listener, @NonNull int[] controllers) {
        SparseArray<Set<ControllerEventListener>> sparseArray = this.controllerEventListenerMap;
        synchronized (sparseArray) {
            ArrayList<Integer> resultList = new ArrayList<Integer>();
            for (int controllerId : controllers) {
                Set listeners = (Set)this.controllerEventListenerMap.get(controllerId);
                if (listeners != null && listeners.contains(listener)) {
                    listeners.remove(listener);
                } else {
                    resultList.add(controllerId);
                }
                this.controllerEventListenerMap.put(controllerId, (Object)listeners);
            }
            int[] resultPrimitiveArray = new int[resultList.size()];
            for (int i = 0; i < resultPrimitiveArray.length; ++i) {
                Integer resultValue = (Integer)resultList.get(i);
                if (resultValue == null) continue;
                resultPrimitiveArray[i] = resultValue;
            }
            return resultPrimitiveArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addMetaEventListener(@NonNull MetaEventListener listener) {
        Set<MetaEventListener> set = this.metaEventListeners;
        synchronized (set) {
            return this.metaEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetaEventListener(@NonNull MetaEventListener listener) {
        Set<MetaEventListener> set = this.metaEventListeners;
        synchronized (set) {
            this.metaEventListeners.remove(listener);
        }
    }

    @Override
    public int getLoopCount() {
        return this.loopCount;
    }

    @Override
    public void setLoopCount(int count) {
        if (count != -1 && count < 0) {
            throw new IllegalArgumentException("Invalid loop count value:" + count);
        }
        this.loopCount = count;
    }

    @Override
    public long getLoopStartPoint() {
        return this.loopStartPoint;
    }

    @Override
    public void setLoopStartPoint(long tick) {
        if (tick > this.getTickLength() || this.loopEndPoint != -1L && tick > this.loopEndPoint || tick < 0L) {
            throw new IllegalArgumentException("Invalid loop start point value:" + tick);
        }
        this.loopStartPoint = tick;
    }

    @Override
    public long getLoopEndPoint() {
        return this.loopEndPoint;
    }

    @Override
    public void setLoopEndPoint(long tick) {
        if (tick > this.getTickLength() || tick != -1L && this.loopStartPoint > tick || tick < -1L) {
            throw new IllegalArgumentException("Invalid loop end point value:" + tick);
        }
        this.loopEndPoint = tick;
    }

    @Override
    @NonNull
    public Sequencer.SyncMode getMasterSyncMode() {
        return this.masterSyncMode;
    }

    @Override
    public void setMasterSyncMode(@NonNull Sequencer.SyncMode sync) {
        for (Sequencer.SyncMode availableMode : this.getMasterSyncModes()) {
            if (availableMode != sync) continue;
            this.masterSyncMode = sync;
        }
    }

    @Override
    @NonNull
    public Sequencer.SyncMode[] getMasterSyncModes() {
        return MASTER_SYNC_MODES;
    }

    @Override
    public long getMicrosecondPosition() {
        return (long)((float)this.getTickPosition() / this.getTicksPerMicrosecond());
    }

    @Override
    public void setMicrosecondPosition(long microseconds) {
        this.setTickPosition((long)(this.getTicksPerMicrosecond() * (float)microseconds));
    }

    float getTicksPerMicrosecond() {
        if (this.sequence == null) {
            return Float.NaN;
        }
        float ticksPerMicrosecond = this.sequence.getDivisionType() == 0.0f ? this.tempoInBPM / 60.0f * (float)this.sequence.getResolution() / 1000000.0f : this.sequence.getDivisionType() * (float)this.sequence.getResolution() / 1000000.0f;
        return ticksPerMicrosecond;
    }

    @Override
    public long getMicrosecondLength() {
        return this.sequence.getMicrosecondLength();
    }

    @Override
    public Sequence getSequence() {
        return this.sequence;
    }

    @Override
    public void setSequence(@NonNull InputStream stream) throws IOException, InvalidMidiDataException {
        this.setSequence(new StandardMidiFileReader().getSequence(stream));
    }

    @Override
    public void setSequence(@Nullable Sequence sequence) throws InvalidMidiDataException {
        this.sequence = sequence;
        if (this.sequencerThread != null && sequence != null) {
            this.sequencerThread.needRefreshPlayingTrack = true;
        }
    }

    @Override
    @NonNull
    public Sequencer.SyncMode getSlaveSyncMode() {
        return this.slaveSyncMode;
    }

    @Override
    public void setSlaveSyncMode(@NonNull Sequencer.SyncMode sync) {
        for (Sequencer.SyncMode availableMode : this.getSlaveSyncModes()) {
            if (availableMode != sync) continue;
            this.slaveSyncMode = sync;
        }
    }

    @Override
    @NonNull
    public Sequencer.SyncMode[] getSlaveSyncModes() {
        return SLAVE_SYNC_MODES;
    }

    @Override
    public float getTempoFactor() {
        return this.tempoFactor;
    }

    @Override
    public void setTempoFactor(float factor) {
        if (factor <= 0.0f) {
            throw new IllegalArgumentException("The tempo factor must be larger than 0f.");
        }
        this.tempoFactor = factor;
    }

    @Override
    public float getTempoInBPM() {
        return this.tempoInBPM;
    }

    @Override
    public void setTempoInBPM(float bpm) {
        this.tempoInBPM = bpm;
    }

    @Override
    public float getTempoInMPQ() {
        return 6.0E7f / this.tempoInBPM;
    }

    @Override
    public void setTempoInMPQ(float mpq) {
        this.tempoInBPM = 6.0E7f / mpq;
    }

    @Override
    public long getTickLength() {
        if (this.sequence == null) {
            return 0L;
        }
        return this.sequence.getTickLength();
    }

    @Override
    public long getTickPosition() {
        if (this.sequencerThread == null) {
            return 0L;
        }
        return this.sequencerThread.getTickPosition();
    }

    @Override
    public void setTickPosition(long tick) {
        if (this.sequencerThread != null) {
            this.sequencerThread.setTickPosition(tick);
        }
    }

    @Override
    public boolean getTrackMute(int track) {
        return this.trackMute.get(track);
    }

    @Override
    public void setTrackMute(int track, boolean mute) {
        this.trackMute.put(track, mute);
    }

    @Override
    public boolean getTrackSolo(int track) {
        return this.trackSolo.get(track);
    }

    @Override
    public void setTrackSolo(int track, boolean solo) {
        this.trackSolo.put(track, solo);
    }

    @Override
    public void recordDisable(@Nullable Track track) {
        if (track == null) {
            this.recordEnable.clear();
        } else {
            Set<Integer> trackRecordEnable = this.recordEnable.get(track);
            if (trackRecordEnable != null) {
                this.recordEnable.put(track, null);
            }
        }
    }

    @Override
    public void recordEnable(@NonNull Track track, int channel) {
        Set<Integer> trackRecordEnable = this.recordEnable.get(track);
        if (trackRecordEnable == null) {
            trackRecordEnable = new HashSet<Integer>();
        }
        if (channel == -1) {
            for (int i = 0; i < 16; ++i) {
                trackRecordEnable.add(i);
            }
            this.recordEnable.put(track, trackRecordEnable);
        } else if (channel >= 0 && channel < 16) {
            trackRecordEnable.add(channel);
            this.recordEnable.put(track, trackRecordEnable);
        }
    }

    @Override
    public void startRecording() {
        if (this.sequencerThread != null) {
            this.sequencerThread.startRecording();
            this.sequencerThread.startPlaying();
        }
    }

    @Override
    public boolean isRecording() {
        return this.isRecording;
    }

    @Override
    public void stopRecording() {
        if (this.sequencerThread != null) {
            this.sequencerThread.stopRecording();
        }
    }

    @Override
    public void start() {
        if (this.sequencerThread != null) {
            this.sequencerThread.startPlaying();
        }
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void stop() {
        if (this.sequencerThread != null) {
            this.sequencerThread.stopRecording();
            this.sequencerThread.stopPlaying();
        }
    }

    private class SequencerThread
    extends Thread {
        private long tickPosition = 0L;
        private long recordingStartedTime;
        private long recordStartedTick;
        private Track recordingTrack;
        private Track playingTrack = null;
        private long tickPositionSetTime;
        private long runningStoppedTime;
        private boolean needRefreshPlayingTrack = false;

        private SequencerThread() {
        }

        private long getTickPosition() {
            if (SequencerImpl.this.isRunning) {
                return (long)((float)this.tickPosition + (float)(System.currentTimeMillis() - this.tickPositionSetTime) * 1000.0f * SequencerImpl.this.getTicksPerMicrosecond());
            }
            return (long)((float)this.tickPosition + (float)(this.runningStoppedTime - this.tickPositionSetTime) * 1000.0f * SequencerImpl.this.getTicksPerMicrosecond());
        }

        private void setTickPosition(long tick) {
            this.tickPosition = tick;
            if (SequencerImpl.this.isRunning) {
                this.tickPositionSetTime = System.currentTimeMillis();
            }
        }

        private void startRecording() {
            if (SequencerImpl.this.isRecording) {
                return;
            }
            this.recordingTrack = SequencerImpl.this.sequence.createTrack();
            this.recordingStartedTime = System.currentTimeMillis();
            this.recordStartedTick = this.getTickPosition();
            SequencerImpl.this.isRecording = true;
        }

        private void stopRecording() {
            if (!SequencerImpl.this.isRecording) {
                return;
            }
            long recordEndedTime = System.currentTimeMillis();
            SequencerImpl.this.isRecording = false;
            HashSet<MidiEvent> eventToRemoval = new HashSet<MidiEvent>();
            for (Track track : SequencerImpl.this.sequence.getTracks()) {
                Set<Integer> recordEnableChannels = SequencerImpl.this.recordEnable.get(track);
                eventToRemoval.clear();
                for (int trackIndex = 0; trackIndex < track.size(); ++trackIndex) {
                    MidiEvent midiEvent = track.get(trackIndex);
                    if (!this.isRecordable(recordEnableChannels, midiEvent) || midiEvent.getTick() < this.recordingStartedTime || midiEvent.getTick() > recordEndedTime) continue;
                    eventToRemoval.add(midiEvent);
                }
                for (MidiEvent event : eventToRemoval) {
                    track.remove(event);
                }
                for (int eventIndex = 0; eventIndex < this.recordingTrack.size(); ++eventIndex) {
                    if (!this.isRecordable(recordEnableChannels, this.recordingTrack.get(eventIndex))) continue;
                    track.add(this.recordingTrack.get(eventIndex));
                }
                Track.TrackUtils.sortEvents(track);
            }
            this.needRefreshPlayingTrack = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startPlaying() {
            if (SequencerImpl.this.isRunning) {
                return;
            }
            this.tickPosition = SequencerImpl.this.getLoopStartPoint();
            this.tickPositionSetTime = System.currentTimeMillis();
            SequencerImpl.this.isRunning = true;
            SequencerThread sequencerThread = this;
            synchronized (sequencerThread) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopPlaying() {
            if (!SequencerImpl.this.isRunning) {
                SequencerThread sequencerThread = this;
                synchronized (sequencerThread) {
                    this.notifyAll();
                }
                this.interrupt();
                return;
            }
            SequencerImpl.this.isRunning = false;
            this.runningStoppedTime = System.currentTimeMillis();
            SequencerThread sequencerThread = this;
            synchronized (sequencerThread) {
                this.notifyAll();
            }
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireEventListeners(@NonNull MidiMessage message) {
            ShortMessage shortMessage;
            if (message instanceof MetaMessage) {
                Set<MetaEventListener> set = SequencerImpl.this.metaEventListeners;
                synchronized (set) {
                    try {
                        for (MetaEventListener metaEventListener : SequencerImpl.this.metaEventListeners) {
                            metaEventListener.meta((MetaMessage)message);
                        }
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        // empty catch block
                    }
                }
            }
            if (message instanceof ShortMessage && (shortMessage = (ShortMessage)message).getCommand() == 176) {
                SparseArray<Set<ControllerEventListener>> sparseArray = SequencerImpl.this.controllerEventListenerMap;
                synchronized (sparseArray) {
                    try {
                        Set eventListeners = (Set)SequencerImpl.this.controllerEventListenerMap.get(shortMessage.getData1());
                        if (eventListeners != null) {
                            for (ControllerEventListener eventListener : eventListeners) {
                                eventListener.controlChange(shortMessage);
                            }
                        }
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            this.refreshPlayingTrack();
            Receiver midiEventRecordingReceiver = new Receiver(){

                @Override
                public void send(@NonNull MidiMessage message, long timeStamp) {
                    if (SequencerImpl.this.isRecording) {
                        SequencerThread.this.recordingTrack.add(new MidiEvent(message, (long)((float)SequencerThread.this.recordStartedTick + (float)(System.currentTimeMillis() - SequencerThread.this.recordingStartedTime) * 1000.0f * SequencerImpl.this.getTicksPerMicrosecond())));
                    }
                    SequencerThread.this.fireEventListeners(message);
                }

                @Override
                public void close() {
                }
            };
            List<Transmitter> list = SequencerImpl.this.transmitters;
            synchronized (list) {
                for (Transmitter transmitter : SequencerImpl.this.transmitters) {
                    transmitter.setReceiver(midiEventRecordingReceiver);
                }
            }
            while (SequencerImpl.this.isOpen) {
                SequencerThread sequencerThread = this;
                synchronized (sequencerThread) {
                    try {
                        while (!SequencerImpl.this.isRunning && SequencerImpl.this.isOpen) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.playingTrack == null) {
                    if (this.needRefreshPlayingTrack) {
                        this.refreshPlayingTrack();
                    }
                    if (this.playingTrack == null) continue;
                }
                int loop = 0;
                while (loop < SequencerImpl.this.getLoopCount() + 1) {
                    if (this.needRefreshPlayingTrack) {
                        this.refreshPlayingTrack();
                    }
                    for (int i = 0; i < this.playingTrack.size(); ++i) {
                        MetaMessage metaMessage;
                        MidiEvent midiEvent = this.playingTrack.get(i);
                        MidiMessage midiMessage = midiEvent.getMessage();
                        if (this.needRefreshPlayingTrack) {
                            if (midiEvent.getTick() < this.tickPosition) {
                                Object object;
                                if (midiMessage instanceof MetaMessage) {
                                    MetaMessage metaMessage2 = (MetaMessage)midiMessage;
                                    if (this.processTempoChange(metaMessage2)) continue;
                                    object = SequencerImpl.this.receivers;
                                    synchronized (object) {
                                        for (Receiver receiver2 : SequencerImpl.this.receivers) {
                                            receiver2.send(midiMessage, 0L);
                                        }
                                        continue;
                                    }
                                }
                                if (midiMessage instanceof SysexMessage) {
                                    List<Receiver> metaMessage2 = SequencerImpl.this.receivers;
                                    synchronized (metaMessage2) {
                                        for (Receiver receiver : SequencerImpl.this.receivers) {
                                            receiver.send(midiMessage, 0L);
                                        }
                                        continue;
                                    }
                                }
                                if (!(midiMessage instanceof ShortMessage)) continue;
                                ShortMessage shortMessage = (ShortMessage)midiMessage;
                                switch (shortMessage.getCommand()) {
                                    case 128: 
                                    case 144: {
                                        break;
                                    }
                                    default: {
                                        object = SequencerImpl.this.receivers;
                                        synchronized (object) {
                                            for (Receiver receiver : SequencerImpl.this.receivers) {
                                                receiver.send(midiMessage, 0L);
                                            }
                                            break;
                                        }
                                    }
                                }
                                continue;
                            }
                            this.needRefreshPlayingTrack = false;
                        }
                        if (midiEvent.getTick() < SequencerImpl.this.getLoopStartPoint() || SequencerImpl.this.getLoopEndPoint() != -1L && midiEvent.getTick() > SequencerImpl.this.getLoopEndPoint()) {
                            this.tickPosition = midiEvent.getTick();
                            this.tickPositionSetTime = System.currentTimeMillis();
                            continue;
                        }
                        try {
                            long sleepLength = (long)(1.0f / SequencerImpl.this.getTicksPerMicrosecond() * (float)(midiEvent.getTick() - this.tickPosition) / 1000.0f / SequencerImpl.this.getTempoFactor());
                            if (sleepLength > 0L) {
                                SequencerThread.sleep(sleepLength);
                            }
                            this.tickPosition = midiEvent.getTick();
                            this.tickPositionSetTime = System.currentTimeMillis();
                        }
                        catch (InterruptedException sleepLength) {
                            // empty catch block
                        }
                        if (!SequencerImpl.this.isRunning || this.needRefreshPlayingTrack) break;
                        if (midiMessage instanceof MetaMessage && this.processTempoChange(metaMessage = (MetaMessage)midiMessage)) {
                            this.fireEventListeners(midiMessage);
                            continue;
                        }
                        List<Receiver> list2 = SequencerImpl.this.receivers;
                        synchronized (list2) {
                            for (Receiver receiver : SequencerImpl.this.receivers) {
                                receiver.send(midiMessage, 0L);
                            }
                        }
                        this.fireEventListeners(midiMessage);
                    }
                    loop = SequencerImpl.this.getLoopCount() == -1 ? loop : loop + 1;
                }
                SequencerImpl.this.isRunning = false;
                this.runningStoppedTime = System.currentTimeMillis();
            }
        }

        private boolean processTempoChange(@NonNull MetaMessage metaMessage) {
            byte[] message;
            if (metaMessage.getLength() == 6 && metaMessage.getStatus() == 255 && (message = metaMessage.getMessage()) != null && (message[1] & 0xFF) == 81 && message[2] == 3) {
                int tempo = message[5] & 0xFF | (message[4] & 0xFF) << 8 | (message[3] & 0xFF) << 16;
                SequencerImpl.this.setTempoInMPQ(tempo);
                return true;
            }
            return false;
        }

        private void refreshPlayingTrack() {
            if (SequencerImpl.this.sequence == null) {
                return;
            }
            Track[] tracks = SequencerImpl.this.sequence.getTracks();
            if (tracks.length > 0) {
                try {
                    this.playingTrack = Track.TrackUtils.mergeSequenceToTrack(SequencerImpl.this, SequencerImpl.this.recordEnable);
                }
                catch (InvalidMidiDataException invalidMidiDataException) {
                    // empty catch block
                }
            }
        }

        private boolean isRecordable(@Nullable Collection<Integer> recordEnableChannels, @NonNull MidiEvent midiEvent) {
            if (recordEnableChannels == null) {
                return false;
            }
            if (recordEnableChannels.contains(-1)) {
                return true;
            }
            int status = midiEvent.getMessage().getStatus();
            switch (status & 0xF0) {
                case 128: 
                case 144: 
                case 160: 
                case 176: 
                case 192: 
                case 208: 
                case 224: {
                    return recordEnableChannels.contains(status & 0xF);
                }
            }
            return true;
        }
    }
}

