/*
 * Decompiled with CFR 0.152.
 */
package jp.kshoji.javax.sound.midi;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import jp.kshoji.javax.sound.midi.InvalidMidiDataException;
import jp.kshoji.javax.sound.midi.MidiMessage;

public class SysexMessage
extends MidiMessage {
    public SysexMessage() {
        this(new byte[]{-16, -9});
    }

    protected SysexMessage(@NonNull byte[] data) {
        super(data);
    }

    public SysexMessage(@NonNull byte[] data, int length) throws InvalidMidiDataException {
        super(null);
        this.setMessage(data, length);
    }

    public SysexMessage(int status, @NonNull byte[] data, int length) throws InvalidMidiDataException {
        super(null);
        this.setMessage(status, data, length);
    }

    @Override
    public void setMessage(@Nullable byte[] data, int length) throws InvalidMidiDataException {
        if (data == null) {
            throw new InvalidMidiDataException("SysexMessage data is null");
        }
        int status = data[0] & 0xFF;
        if (status != 240 && status != 247) {
            throw new InvalidMidiDataException("Invalid status byte for SysexMessage: 0x" + Integer.toHexString(status));
        }
        super.setMessage(data, length);
    }

    public void setMessage(int status, @NonNull byte[] data, int length) throws InvalidMidiDataException {
        if (status != 240 && status != 247) {
            throw new InvalidMidiDataException("Invalid status byte for SysexMessage: 0x" + Integer.toHexString(status));
        }
        this.data = new byte[data.length + 1];
        this.length = this.data.length;
        this.data[0] = (byte)(status & 0xFF);
        if (data.length > 0) {
            System.arraycopy(data, 0, this.data, 1, data.length);
        }
    }

    @NonNull
    public byte[] getData() {
        byte[] result = new byte[this.data.length];
        System.arraycopy(this.data, 0, result, 0, result.length);
        return result;
    }

    @Override
    public Object clone() {
        return new SysexMessage(this.getData());
    }
}

