/*
 * Decompiled with CFR 0.152.
 */
package jp.kshoji.javax.sound.midi;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import jp.kshoji.javax.sound.midi.ControllerEventListener;
import jp.kshoji.javax.sound.midi.InvalidMidiDataException;
import jp.kshoji.javax.sound.midi.MetaEventListener;
import jp.kshoji.javax.sound.midi.MidiDevice;
import jp.kshoji.javax.sound.midi.Sequence;
import jp.kshoji.javax.sound.midi.Track;

public interface Sequencer
extends MidiDevice {
    public static final int LOOP_CONTINUOUSLY = -1;

    @NonNull
    public SyncMode[] getMasterSyncModes();

    @NonNull
    public SyncMode getMasterSyncMode();

    public void setMasterSyncMode(@NonNull SyncMode var1);

    @NonNull
    public SyncMode[] getSlaveSyncModes();

    @NonNull
    public SyncMode getSlaveSyncMode();

    public void setSlaveSyncMode(@NonNull SyncMode var1);

    @Nullable
    public Sequence getSequence();

    public void setSequence(@NonNull InputStream var1) throws IOException, InvalidMidiDataException;

    public void setSequence(@Nullable Sequence var1) throws InvalidMidiDataException;

    @NonNull
    public int[] addControllerEventListener(@NonNull ControllerEventListener var1, @NonNull int[] var2);

    @NonNull
    public int[] removeControllerEventListener(@NonNull ControllerEventListener var1, @NonNull int[] var2);

    public boolean addMetaEventListener(@NonNull MetaEventListener var1);

    public void removeMetaEventListener(@NonNull MetaEventListener var1);

    public boolean isRecording();

    public boolean isRunning();

    public void recordDisable(@Nullable Track var1);

    public void recordEnable(@NonNull Track var1, int var2);

    public int getLoopCount();

    public void setLoopCount(int var1);

    public long getLoopStartPoint();

    public void setLoopStartPoint(long var1);

    public long getLoopEndPoint();

    public void setLoopEndPoint(long var1);

    public float getTempoFactor();

    public void setTempoFactor(float var1);

    public float getTempoInBPM();

    public void setTempoInBPM(float var1);

    public float getTempoInMPQ();

    public void setTempoInMPQ(float var1);

    public long getTickLength();

    public long getMicrosecondLength();

    public long getTickPosition();

    public void setTickPosition(long var1);

    @Override
    public long getMicrosecondPosition();

    public void setMicrosecondPosition(long var1);

    public boolean getTrackMute(int var1);

    public void setTrackMute(int var1, boolean var2);

    public boolean getTrackSolo(int var1);

    public void setTrackSolo(int var1, boolean var2);

    public void start();

    public void startRecording();

    public void stop();

    public void stopRecording();

    public static class SyncMode {
        public static final SyncMode INTERNAL_CLOCK = new SyncMode("Internal Clock");
        public static final SyncMode NO_SYNC = new SyncMode("No Sync");
        private final String name;

        protected SyncMode(@NonNull String name) {
            this.name = name;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SyncMode other = (SyncMode)obj;
            return this.name.equals(other.name);
        }

        public final int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public final String toString() {
            return this.name;
        }
    }
}

