/*
 * Decompiled with CFR 0.152.
 */
package jp.kshoji.javax.sound.midi;

import androidx.annotation.NonNull;
import java.util.List;
import jp.kshoji.javax.sound.midi.MidiUnavailableException;
import jp.kshoji.javax.sound.midi.Receiver;
import jp.kshoji.javax.sound.midi.Transmitter;

public interface MidiDevice {
    @NonNull
    public Info getDeviceInfo();

    public void open() throws MidiUnavailableException;

    public void close();

    public boolean isOpen();

    public long getMicrosecondPosition();

    public int getMaxReceivers();

    public int getMaxTransmitters();

    @NonNull
    public Receiver getReceiver() throws MidiUnavailableException;

    @NonNull
    public List<Receiver> getReceivers();

    @NonNull
    public Transmitter getTransmitter() throws MidiUnavailableException;

    @NonNull
    public List<Transmitter> getTransmitters();

    public static class Info {
        private final String name;
        private final String vendor;
        private final String description;
        private final String version;

        public Info(@NonNull String name, @NonNull String vendor, @NonNull String description, @NonNull String version) {
            this.name = name;
            this.vendor = vendor;
            this.description = description;
            this.version = version;
        }

        @NonNull
        public final String getName() {
            return this.name;
        }

        @NonNull
        public final String getVendor() {
            return this.vendor;
        }

        @NonNull
        public final String getDescription() {
            return this.description;
        }

        @NonNull
        public final String getVersion() {
            return this.version;
        }

        @NonNull
        public final String toString() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.description.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.vendor.hashCode();
            result = 31 * result + this.version.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Info other = (Info)obj;
            if (!this.description.equals(other.description)) {
                return false;
            }
            if (!this.name.equals(other.name)) {
                return false;
            }
            if (!this.vendor.equals(other.vendor)) {
                return false;
            }
            return this.version.equals(other.version);
        }
    }
}

