/*
 * Decompiled with CFR 0.152.
 */
package jp.kshoji.javax.sound.midi;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Arrays;
import jp.kshoji.javax.sound.midi.InvalidMidiDataException;
import jp.kshoji.javax.sound.midi.MidiMessage;

public class MetaMessage
extends MidiMessage {
    public static final int META = 255;
    public static final int TYPE_END_OF_TRACK = 47;
    public static final int TYPE_TEMPO = 81;
    private static final byte[] defaultMessage = new byte[]{-1, 0, 0};
    private static final byte[] emptyData = new byte[0];
    private int dataLength = 0;

    public MetaMessage() {
        this(defaultMessage);
    }

    protected MetaMessage(@NonNull byte[] data) {
        super(data);
        if (data.length >= 3) {
            this.dataLength = data.length - 3;
            for (int pos = 2; pos < data.length && (data[pos] & 0x80) != 0; ++pos) {
                --this.dataLength;
            }
        }
        if (this.dataLength < 0) {
            throw new NegativeArraySizeException("Invalid meta event. data: " + Arrays.toString(data));
        }
    }

    public MetaMessage(int type, @Nullable byte[] data, int length) throws InvalidMidiDataException {
        super(null);
        this.setMessage(type, data, length);
    }

    public void setMessage(int type, @Nullable byte[] data, int length) throws InvalidMidiDataException {
        if (type >= 128 || type < 0) {
            throw new InvalidMidiDataException("Invalid meta event. type: " + type);
        }
        byte[] newData = data == null ? emptyData : data;
        int headerLength = 2 + MetaMessage.getMidiValuesLength(newData.length);
        this.dataLength = newData.length;
        this.data = new byte[headerLength + newData.length];
        this.length = this.data.length;
        this.data[0] = -1;
        this.data[1] = (byte)type;
        MetaMessage.writeMidiValues(this.data, 2, newData.length);
        if (newData.length > 0) {
            System.arraycopy(newData, 0, this.data, headerLength, newData.length);
        }
    }

    public int getType() {
        if (this.data != null && this.data.length >= 2) {
            return this.data[1] & 0xFF;
        }
        return 0;
    }

    @NonNull
    public byte[] getData() {
        if (this.data == null) {
            return emptyData;
        }
        byte[] returnedArray = new byte[this.dataLength];
        System.arraycopy(this.data, this.data.length - this.dataLength, returnedArray, 0, this.dataLength);
        return returnedArray;
    }

    @Override
    @NonNull
    public Object clone() {
        if (this.data == null) {
            return new MetaMessage(emptyData);
        }
        byte[] result = new byte[this.data.length];
        System.arraycopy(this.data, 0, result, 0, this.data.length);
        return new MetaMessage(result);
    }

    private static int getMidiValuesLength(long value) {
        int length = 0;
        long currentValue = value;
        do {
            ++length;
        } while ((currentValue >>= 7) > 0L);
        return length;
    }

    private static void writeMidiValues(@NonNull byte[] data, int offset, long value) {
        int shift;
        for (shift = 63; shift > 0 && (value & (long)(127 << shift)) == 0L; shift -= 7) {
        }
        int currentOffset = offset;
        while (shift > 0) {
            data[currentOffset++] = (byte)((value & (long)(127 << shift)) >> shift | 0x80L);
            shift -= 7;
        }
        data[currentOffset] = (byte)(value & 0x7FL);
    }
}

