/*
 * Decompiled with CFR 0.152.
 */
package cn.sherlock.media;

import android.media.AudioTrack;
import cn.sherlock.javax.sound.sampled.AudioFormat;
import cn.sherlock.javax.sound.sampled.DataLine;
import cn.sherlock.javax.sound.sampled.LineUnavailableException;
import cn.sherlock.javax.sound.sampled.SourceDataLine;

public class SourceDataLineImpl
implements SourceDataLine {
    private AudioTrack audioTrack;
    private int bufferSize;
    private AudioFormat format = new AudioFormat(44100.0f, 16, 2, true, false);

    public SourceDataLineImpl() {
    }

    public SourceDataLineImpl(AudioFormat format) {
        this.format = format;
    }

    @Override
    public void drain() {
        this.flush();
    }

    @Override
    public void flush() {
        if (this.audioTrack != null) {
            this.audioTrack.flush();
        }
    }

    @Override
    public void start() {
        if (this.audioTrack != null) {
            this.audioTrack.play();
        }
    }

    @Override
    public void stop() {
        if (this.audioTrack != null) {
            this.audioTrack.stop();
        }
    }

    @Override
    public void close() {
        if (this.audioTrack != null) {
            this.audioTrack.stop();
            this.audioTrack.release();
            this.audioTrack = null;
        }
    }

    @Override
    public boolean isOpen() {
        return this.audioTrack != null;
    }

    @Override
    public boolean isRunning() {
        if (this.audioTrack != null) {
            return this.audioTrack.getPlayState() == 3;
        }
        return false;
    }

    @Override
    public boolean isActive() {
        return this.isRunning();
    }

    @Override
    public AudioFormat getFormat() {
        return this.format;
    }

    @Override
    public int getBufferSize() {
        if (this.audioTrack != null) {
            return this.bufferSize;
        }
        return 0;
    }

    @Override
    public int available() {
        return 0;
    }

    @Override
    public int getFramePosition() {
        if (this.audioTrack != null) {
            return this.audioTrack.getPlaybackHeadPosition();
        }
        return 0;
    }

    @Override
    public long getLongFramePosition() {
        if (this.audioTrack != null) {
            return this.audioTrack.getPlaybackHeadPosition();
        }
        return 0L;
    }

    @Override
    @Deprecated
    public long getMicrosecondPosition() {
        if (this.audioTrack != null) {
            return this.audioTrack.getPlaybackHeadPosition() * 1000;
        }
        return 0L;
    }

    @Override
    @Deprecated
    public float getLevel() {
        if (this.audioTrack != null) {
            return 0.0f;
        }
        return 0.0f;
    }

    @Override
    @Deprecated
    public DataLine.Info getLineInfo() {
        return null;
    }

    @Override
    public void open() throws LineUnavailableException {
        int bufferSizeInBytes;
        int channelConfig;
        int sampleRateInHz = (int)this.format.getSampleRate();
        if (this.format.getChannels() == 1) {
            channelConfig = 4;
        } else if (this.format.getChannels() == 2) {
            channelConfig = 12;
        } else {
            throw new IllegalArgumentException("format.getChannels() must in (1,2)");
        }
        this.bufferSize = bufferSizeInBytes = AudioTrack.getMinBufferSize((int)sampleRateInHz, (int)channelConfig, (int)2);
        this.audioTrack = new AudioTrack(3, sampleRateInHz, channelConfig, 2, bufferSizeInBytes, 1);
    }

    @Override
    public void open(AudioFormat format, int bufferSize) throws LineUnavailableException {
        int channelConfig;
        this.format = format;
        this.bufferSize = bufferSize;
        int sampleRateInHz = (int)format.getSampleRate();
        if (format.getChannels() == 1) {
            channelConfig = 4;
        } else if (format.getChannels() == 2) {
            channelConfig = 12;
        } else {
            throw new IllegalArgumentException("format.getChannels() must in (1,2)");
        }
        this.audioTrack = new AudioTrack(3, sampleRateInHz, channelConfig, 2, bufferSize, 1);
    }

    @Override
    public void open(AudioFormat format) throws LineUnavailableException {
        int bufferSizeInBytes;
        int channelConfig;
        this.format = format;
        int sampleRateInHz = (int)format.getSampleRate();
        if (format.getChannels() == 1) {
            channelConfig = 4;
        } else if (format.getChannels() == 2) {
            channelConfig = 12;
        } else {
            throw new IllegalArgumentException("format.getChannels() must in (1,2)");
        }
        this.bufferSize = bufferSizeInBytes = AudioTrack.getMinBufferSize((int)sampleRateInHz, (int)channelConfig, (int)2);
        this.audioTrack = new AudioTrack(3, sampleRateInHz, channelConfig, 2, bufferSizeInBytes, 1);
    }

    @Override
    public int write(byte[] b, int off, int len) {
        if (this.audioTrack != null) {
            return this.audioTrack.write(b, off, len);
        }
        return 0;
    }
}

