/*
 * Decompiled with CFR 0.152.
 */
package cn.sherlock.javax.sound.sampled;

import cn.sherlock.javax.sound.sampled.AutoCloseable;
import cn.sherlock.javax.sound.sampled.LineUnavailableException;

public interface Line
extends AutoCloseable {
    public Info getLineInfo();

    public void open() throws LineUnavailableException;

    @Override
    public void close();

    public boolean isOpen();

    public static class Info {
        private final Class lineClass;

        public Info(Class<?> lineClass) {
            this.lineClass = lineClass == null ? Line.class : lineClass;
        }

        public Class<?> getLineClass() {
            return this.lineClass;
        }

        public boolean matches(Info info) {
            if (!this.getClass().isInstance(info)) {
                return false;
            }
            return this.getLineClass().isAssignableFrom(info.getLineClass());
        }

        public String toString() {
            String fullPackagePath = "javax.sound.sampled.";
            String initialString = new String(this.getLineClass().toString());
            int index = initialString.indexOf(fullPackagePath);
            String finalString = index != -1 ? initialString.substring(0, index) + initialString.substring(index + fullPackagePath.length(), initialString.length()) : initialString;
            return finalString;
        }
    }
}

