/*
 * Decompiled with CFR 0.152.
 */
package cn.sherlock.javax.sound.sampled;

import cn.sherlock.com.sun.media.sound.AudioFloatFormatConverter;
import cn.sherlock.com.sun.media.sound.WaveExtensibleFileReader;
import cn.sherlock.com.sun.media.sound.WaveFloatFileReader;
import cn.sherlock.javax.sound.sampled.AudioFileFormat;
import cn.sherlock.javax.sound.sampled.AudioFormat;
import cn.sherlock.javax.sound.sampled.AudioInputStream;
import cn.sherlock.javax.sound.sampled.LineUnavailableException;
import cn.sherlock.javax.sound.sampled.SourceDataLine;
import cn.sherlock.javax.sound.sampled.UnsupportedAudioFileException;
import cn.sherlock.javax.sound.sampled.spi.AudioFileReader;
import cn.sherlock.javax.sound.sampled.spi.FormatConversionProvider;
import cn.sherlock.media.SourceDataLineImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class AudioSystem {
    public static final int NOT_SPECIFIED = -1;

    private AudioSystem() {
    }

    public static SourceDataLine getSourceDataLine(AudioFormat format) throws LineUnavailableException {
        return new SourceDataLineImpl(format);
    }

    public static AudioFileFormat getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        List<AudioFileReader> providers = AudioSystem.getAudioFileReaders();
        AudioFileFormat format = null;
        for (int i = 0; i < providers.size(); ++i) {
            AudioFileReader reader = providers.get(i);
            try {
                format = reader.getAudioFileFormat(stream);
                break;
            }
            catch (UnsupportedAudioFileException e) {
                continue;
            }
        }
        if (format == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return format;
    }

    public static AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        List<AudioFileReader> providers = AudioSystem.getAudioFileReaders();
        AudioInputStream audioStream = null;
        for (int i = 0; i < providers.size(); ++i) {
            AudioFileReader reader = providers.get(i);
            try {
                audioStream = reader.getAudioInputStream(stream);
                break;
            }
            catch (UnsupportedAudioFileException e) {
                continue;
            }
        }
        if (audioStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input stream");
        }
        return audioStream;
    }

    public static AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        if (sourceStream.getFormat().matches(targetFormat)) {
            return sourceStream;
        }
        List<FormatConversionProvider> codecs = AudioSystem.getFormatConversionProviders();
        for (int i = 0; i < codecs.size(); ++i) {
            FormatConversionProvider codec = codecs.get(i);
            if (!codec.isConversionSupported(targetFormat, sourceStream.getFormat())) continue;
            return codec.getAudioInputStream(targetFormat, sourceStream);
        }
        throw new IllegalArgumentException("Unsupported conversion: " + targetFormat + " from " + sourceStream.getFormat());
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat.Encoding sourceEncoding) {
        List<FormatConversionProvider> codecs = AudioSystem.getFormatConversionProviders();
        Vector<AudioFormat.Encoding> encodings = new Vector<AudioFormat.Encoding>();
        AudioFormat.Encoding[] encs = null;
        for (int i = 0; i < codecs.size(); ++i) {
            FormatConversionProvider codec = codecs.get(i);
            if (!codec.isSourceEncodingSupported(sourceEncoding)) continue;
            encs = codec.getTargetEncodings();
            for (int j = 0; j < encs.length; ++j) {
                encodings.addElement(encs[j]);
            }
        }
        AudioFormat.Encoding[] encs2 = encodings.toArray(new AudioFormat.Encoding[0]);
        return encs2;
    }

    public static AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        List<AudioFileReader> providers = AudioSystem.getAudioFileReaders();
        AudioInputStream audioStream = null;
        for (int i = 0; i < providers.size(); ++i) {
            AudioFileReader reader = providers.get(i);
            try {
                audioStream = reader.getAudioInputStream(file);
                break;
            }
            catch (UnsupportedAudioFileException e) {
                continue;
            }
        }
        if (audioStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input file");
        }
        return audioStream;
    }

    public static AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        List<AudioFileReader> providers = AudioSystem.getAudioFileReaders();
        AudioInputStream audioStream = null;
        for (int i = 0; i < providers.size(); ++i) {
            AudioFileReader reader = providers.get(i);
            try {
                audioStream = reader.getAudioInputStream(url);
                break;
            }
            catch (UnsupportedAudioFileException e) {
                continue;
            }
        }
        if (audioStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input URL");
        }
        return audioStream;
    }

    public static AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        List<FormatConversionProvider> codecs = AudioSystem.getFormatConversionProviders();
        Vector<AudioFormat[]> formats = new Vector<AudioFormat[]>();
        int size = 0;
        int index = 0;
        AudioFormat[] fmts = null;
        for (int i = 0; i < codecs.size(); ++i) {
            FormatConversionProvider codec = codecs.get(i);
            fmts = codec.getTargetFormats(targetEncoding, sourceFormat);
            size += fmts.length;
            formats.addElement(fmts);
        }
        AudioFormat[] fmts2 = new AudioFormat[size];
        for (int i = 0; i < formats.size(); ++i) {
            fmts = (AudioFormat[])formats.get(i);
            for (int j = 0; j < fmts.length; ++j) {
                fmts2[index++] = fmts[j];
            }
        }
        return fmts2;
    }

    private static List<FormatConversionProvider> getFormatConversionProviders() {
        ArrayList<FormatConversionProvider> list = new ArrayList<FormatConversionProvider>();
        list.add(new AudioFloatFormatConverter());
        return list;
    }

    private static List<AudioFileReader> getAudioFileReaders() {
        ArrayList<AudioFileReader> list = new ArrayList<AudioFileReader>();
        list.add(new WaveFloatFileReader());
        list.add(new WaveExtensibleFileReader());
        return list;
    }
}

