/*
 * Decompiled with CFR 0.152.
 */
package cn.sherlock.com.sun.media.sound;

import cn.sherlock.com.sun.media.sound.MidiDeviceReceiver;
import cn.sherlock.com.sun.media.sound.SoftMainMixer;
import cn.sherlock.com.sun.media.sound.SoftSynthesizer;
import java.util.TreeMap;
import jp.kshoji.javax.sound.midi.MidiDevice;
import jp.kshoji.javax.sound.midi.MidiMessage;
import jp.kshoji.javax.sound.midi.ShortMessage;

public class SoftReceiver
implements MidiDeviceReceiver {
    protected boolean open = true;
    private Object control_mutex;
    private SoftSynthesizer synth;
    protected TreeMap<Long, Object> midimessages;
    protected SoftMainMixer mainmixer;

    public SoftReceiver(SoftSynthesizer synth) {
        this.control_mutex = synth.control_mutex;
        this.synth = synth;
        this.mainmixer = synth.getMainMixer();
        if (this.mainmixer != null) {
            this.midimessages = this.mainmixer.midimessages;
        }
    }

    @Override
    public MidiDevice getMidiDevice() {
        return this.synth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(MidiMessage message, long timeStamp) {
        Object object = this.control_mutex;
        synchronized (object) {
            if (!this.open) {
                throw new IllegalStateException("Receiver is not open");
            }
        }
        if (timeStamp != -1L) {
            object = this.control_mutex;
            synchronized (object) {
                this.mainmixer.activity();
                while (this.midimessages.get(timeStamp) != null) {
                    ++timeStamp;
                }
                if (message instanceof ShortMessage && ((ShortMessage)message).getChannel() > 15) {
                    this.midimessages.put(timeStamp, message.clone());
                } else {
                    this.midimessages.put(timeStamp, message.getMessage());
                }
            }
        } else {
            this.mainmixer.processMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.control_mutex;
        synchronized (object) {
            this.open = false;
        }
        this.synth.removeReceiver(this);
    }
}

