/*
 * Decompiled with CFR 0.152.
 */
package cn.sherlock.com.sun.media.sound;

import cn.sherlock.com.sun.media.sound.SoftAbstractResampler;

public class SoftLinearResampler
extends SoftAbstractResampler {
    @Override
    public int getPadding() {
        return 2;
    }

    @Override
    public void interpolate(float[] in, float[] in_offset, float in_end, float[] startpitch, float pitchstep, float[] out, int[] out_offset, int out_end) {
        float ix;
        float pitch = startpitch[0];
        int ox = out_offset[0];
        float ix_end = in_end;
        int ox_end = out_end;
        if (pitchstep == 0.0f) {
            for (ix = in_offset[0]; ix < ix_end && ox < ox_end; ix += pitch) {
                int iix = (int)ix;
                float fix = ix - (float)iix;
                float i = in[iix];
                out[ox++] = i + (in[iix + 1] - i) * fix;
            }
        } else {
            while (ix < ix_end && ox < ox_end) {
                int iix = (int)ix;
                float fix = ix - (float)iix;
                float i = in[iix];
                out[ox++] = i + (in[iix + 1] - i) * fix;
                ix += pitch;
                pitch += pitchstep;
            }
        }
        in_offset[0] = ix;
        out_offset[0] = ox;
        startpitch[0] = pitch;
    }
}

