/*
 * Decompiled with CFR 0.152.
 */
package cn.sherlock.com.sun.media.sound;

import cn.sherlock.com.sun.media.sound.ModelDirectedPlayer;
import cn.sherlock.com.sun.media.sound.ModelDirector;
import cn.sherlock.com.sun.media.sound.ModelInstrument;
import cn.sherlock.com.sun.media.sound.ModelPerformer;
import cn.sherlock.com.sun.media.sound.SoftPerformer;
import jp.kshoji.javax.sound.midi.Instrument;
import jp.kshoji.javax.sound.midi.MidiChannel;

public class SoftInstrument
extends Instrument {
    private SoftPerformer[] performers;
    private ModelPerformer[] modelperformers;
    private Object data;
    private ModelInstrument ins;

    public SoftInstrument(ModelInstrument ins) {
        super(ins.getSoundbank(), ins.getPatch(), ins.getName(), ins.getDataClass());
        this.data = ins.getData();
        this.ins = ins;
        this.initPerformers(ins.getPerformers());
    }

    public SoftInstrument(ModelInstrument ins, ModelPerformer[] overrideperformers) {
        super(ins.getSoundbank(), ins.getPatch(), ins.getName(), ins.getDataClass());
        this.data = ins.getData();
        this.ins = ins;
        this.initPerformers(overrideperformers);
    }

    private void initPerformers(ModelPerformer[] modelperformers) {
        this.modelperformers = modelperformers;
        this.performers = new SoftPerformer[modelperformers.length];
        for (int i = 0; i < modelperformers.length; ++i) {
            this.performers[i] = new SoftPerformer(modelperformers[i]);
        }
    }

    public ModelDirector getDirector(MidiChannel channel, ModelDirectedPlayer player) {
        return this.ins.getDirector(this.modelperformers, channel, player);
    }

    public ModelInstrument getSourceInstrument() {
        return this.ins;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    public SoftPerformer[] getPerformers() {
        return this.performers;
    }
}

