/*
 * Decompiled with CFR 0.152.
 */
package cn.sherlock.com.sun.media.sound;

import cn.sherlock.com.sun.media.sound.AudioFloatInputStream;
import cn.sherlock.com.sun.media.sound.ModelWavetable;
import cn.sherlock.com.sun.media.sound.SoftResampler;
import cn.sherlock.com.sun.media.sound.SoftResamplerStreamer;
import java.io.IOException;
import java.util.Arrays;
import jp.kshoji.javax.sound.midi.MidiChannel;
import jp.kshoji.javax.sound.midi.VoiceStatus;

public abstract class SoftAbstractResampler
implements SoftResampler {
    public abstract int getPadding();

    public abstract void interpolate(float[] var1, float[] var2, float var3, float[] var4, float var5, float[] var6, int[] var7, int var8);

    @Override
    public SoftResamplerStreamer openStreamer() {
        return new ModelAbstractResamplerStream();
    }

    private class ModelAbstractResamplerStream
    implements SoftResamplerStreamer {
        AudioFloatInputStream stream;
        boolean stream_eof = false;
        int loopmode;
        boolean loopdirection = true;
        float loopstart;
        float looplen;
        float target_pitch;
        float[] current_pitch = new float[1];
        boolean started;
        boolean eof;
        int sector_pos = 0;
        int sector_size = 400;
        int sector_loopstart = -1;
        boolean markset = false;
        int marklimit = 0;
        int streampos = 0;
        int nrofchannels = 2;
        boolean noteOff_flag = false;
        float[][] ibuffer;
        boolean ibuffer_order = true;
        float[] sbuffer;
        int pad;
        int pad2;
        float[] ix = new float[1];
        int[] ox = new int[1];
        float samplerateconv = 1.0f;
        float pitchcorrection = 0.0f;

        public ModelAbstractResamplerStream() {
            this.pad = SoftAbstractResampler.this.getPadding();
            this.pad2 = SoftAbstractResampler.this.getPadding() * 2;
            this.ibuffer = new float[2][this.sector_size + this.pad2];
            this.ibuffer_order = true;
        }

        @Override
        public void noteOn(MidiChannel channel, VoiceStatus voice, int noteNumber, int velocity) {
        }

        @Override
        public void noteOff(int velocity) {
            this.noteOff_flag = true;
        }

        @Override
        public void open(ModelWavetable osc, float outputsamplerate) throws IOException {
            this.eof = false;
            this.nrofchannels = osc.getChannels();
            if (this.ibuffer.length < this.nrofchannels) {
                this.ibuffer = new float[this.nrofchannels][this.sector_size + this.pad2];
            }
            this.stream = osc.openStream();
            this.streampos = 0;
            this.stream_eof = false;
            this.pitchcorrection = osc.getPitchcorrection();
            this.samplerateconv = this.stream.getFormat().getSampleRate() / outputsamplerate;
            this.looplen = osc.getLoopLength();
            this.loopstart = osc.getLoopStart();
            this.sector_loopstart = (int)(this.loopstart / (float)this.sector_size);
            --this.sector_loopstart;
            this.sector_pos = 0;
            if (this.sector_loopstart < 0) {
                this.sector_loopstart = 0;
            }
            this.started = false;
            this.loopmode = osc.getLoopType();
            if (this.loopmode != 0) {
                this.markset = false;
                this.marklimit = this.nrofchannels * (int)(this.looplen + (float)this.pad2 + 1.0f);
            } else {
                this.markset = true;
            }
            this.target_pitch = this.samplerateconv;
            this.current_pitch[0] = this.samplerateconv;
            this.ibuffer_order = true;
            this.loopdirection = true;
            this.noteOff_flag = false;
            for (int i = 0; i < this.nrofchannels; ++i) {
                Arrays.fill(this.ibuffer[i], this.sector_size, this.sector_size + this.pad2, 0.0f);
            }
            this.ix[0] = this.pad;
            this.eof = false;
            this.ix[0] = this.sector_size + this.pad;
            this.sector_pos = -1;
            this.streampos = -this.sector_size;
            this.nextBuffer();
        }

        @Override
        public void setPitch(float pitch) {
            this.target_pitch = (float)Math.exp((double)(this.pitchcorrection + pitch) * (Math.log(2.0) / 1200.0)) * this.samplerateconv;
            if (!this.started) {
                this.current_pitch[0] = this.target_pitch;
            }
        }

        public void nextBuffer() throws IOException {
            if (this.ix[0] < (float)this.pad && this.markset) {
                this.stream.reset();
                this.ix[0] = this.ix[0] + (float)(this.streampos - this.sector_loopstart * this.sector_size);
                this.sector_pos = this.sector_loopstart;
                this.streampos = this.sector_pos * this.sector_size;
                this.ix[0] = this.ix[0] + (float)this.sector_size;
                --this.sector_pos;
                this.streampos -= this.sector_size;
                this.stream_eof = false;
            }
            if (this.ix[0] >= (float)(this.sector_size + this.pad) && this.stream_eof) {
                this.eof = true;
                return;
            }
            if (this.ix[0] >= (float)(this.sector_size * 4 + this.pad)) {
                int skips = (int)((this.ix[0] - (float)(this.sector_size * 4) + (float)this.pad) / (float)this.sector_size);
                this.ix[0] = this.ix[0] - (float)(this.sector_size * skips);
                this.sector_pos += skips;
                this.streampos += this.sector_size * skips;
                this.stream.skip(this.sector_size * skips);
            }
            while (this.ix[0] >= (float)(this.sector_size + this.pad)) {
                int ret;
                if (!this.markset && this.sector_pos + 1 == this.sector_loopstart) {
                    this.stream.mark(this.marklimit);
                    this.markset = true;
                }
                this.ix[0] = this.ix[0] - (float)this.sector_size;
                ++this.sector_pos;
                this.streampos += this.sector_size;
                for (int c = 0; c < this.nrofchannels; ++c) {
                    float[] cbuffer = this.ibuffer[c];
                    for (int i = 0; i < this.pad2; ++i) {
                        cbuffer[i] = cbuffer[i + this.sector_size];
                    }
                }
                if (this.nrofchannels == 1) {
                    ret = this.stream.read(this.ibuffer[0], this.pad2, this.sector_size);
                } else {
                    int sret;
                    int slen = this.sector_size * this.nrofchannels;
                    if (this.sbuffer == null || this.sbuffer.length < slen) {
                        this.sbuffer = new float[slen];
                    }
                    if ((sret = this.stream.read(this.sbuffer, 0, slen)) == -1) {
                        ret = -1;
                    } else {
                        ret = sret / this.nrofchannels;
                        for (int i = 0; i < this.nrofchannels; ++i) {
                            float[] buff = this.ibuffer[i];
                            int ix = i;
                            int ix_step = this.nrofchannels;
                            int ox = this.pad2;
                            int j = 0;
                            while (j < ret) {
                                buff[ox] = this.sbuffer[ix];
                                ++j;
                                ix += ix_step;
                                ++ox;
                            }
                        }
                    }
                }
                if (ret == -1) {
                    ret = 0;
                    this.stream_eof = true;
                    for (int i = 0; i < this.nrofchannels; ++i) {
                        Arrays.fill(this.ibuffer[i], this.pad2, this.pad2 + this.sector_size, 0.0f);
                    }
                    return;
                }
                if (ret != this.sector_size) {
                    for (int i = 0; i < this.nrofchannels; ++i) {
                        Arrays.fill(this.ibuffer[i], this.pad2 + ret, this.pad2 + this.sector_size, 0.0f);
                    }
                }
                this.ibuffer_order = true;
            }
        }

        public void reverseBuffers() {
            this.ibuffer_order = !this.ibuffer_order;
            for (int c = 0; c < this.nrofchannels; ++c) {
                float[] cbuff = this.ibuffer[c];
                int len = cbuff.length - 1;
                int len2 = cbuff.length / 2;
                for (int i = 0; i < len2; ++i) {
                    float x = cbuff[i];
                    cbuff[i] = cbuff[len - i];
                    cbuff[len - i] = x;
                }
            }
        }

        @Override
        public int read(float[][] buffer, int offset, int len) throws IOException {
            if (this.eof) {
                return -1;
            }
            if (this.noteOff_flag && (this.loopmode & 2) != 0 && this.loopdirection) {
                this.loopmode = 0;
            }
            float pitchstep = (this.target_pitch - this.current_pitch[0]) / (float)len;
            float[] current_pitch = this.current_pitch;
            this.started = true;
            int[] ox = this.ox;
            ox[0] = offset;
            int ox_end = len + offset;
            float ixend = this.sector_size + this.pad;
            if (!this.loopdirection) {
                ixend = this.pad;
            }
            while (ox[0] != ox_end) {
                int i;
                float bak_pitch;
                int bak_ox;
                float bak_ix;
                this.nextBuffer();
                if (!this.loopdirection) {
                    if ((float)this.streampos < this.loopstart + (float)this.pad && this.ix[0] <= (ixend = this.loopstart - (float)this.streampos + (float)this.pad2)) {
                        if ((this.loopmode & 4) != 0) {
                            this.loopdirection = true;
                            ixend = this.sector_size + this.pad;
                            continue;
                        }
                        this.ix[0] = this.ix[0] + this.looplen;
                        ixend = this.pad;
                        continue;
                    }
                    if (this.ibuffer_order != this.loopdirection) {
                        this.reverseBuffers();
                    }
                    this.ix[0] = (float)(this.sector_size + this.pad2) - this.ix[0];
                    ixend = (float)(this.sector_size + this.pad2) - ixend;
                    ixend += 1.0f;
                    bak_ix = this.ix[0];
                    bak_ox = ox[0];
                    bak_pitch = current_pitch[0];
                    for (i = 0; i < this.nrofchannels; ++i) {
                        if (buffer[i] == null) continue;
                        this.ix[0] = bak_ix;
                        ox[0] = bak_ox;
                        current_pitch[0] = bak_pitch;
                        SoftAbstractResampler.this.interpolate(this.ibuffer[i], this.ix, ixend, current_pitch, pitchstep, buffer[i], ox, ox_end);
                    }
                    this.ix[0] = (float)(this.sector_size + this.pad2) - this.ix[0];
                    ixend -= 1.0f;
                    ixend = (float)(this.sector_size + this.pad2) - ixend;
                    if (!this.eof) continue;
                    current_pitch[0] = this.target_pitch;
                    return ox[0] - offset;
                }
                if (this.loopmode != 0 && (float)(this.streampos + this.sector_size) > this.looplen + this.loopstart + (float)this.pad && this.ix[0] >= (ixend = this.loopstart + this.looplen - (float)this.streampos + (float)this.pad2)) {
                    if ((this.loopmode & 4) != 0 || (this.loopmode & 8) != 0) {
                        this.loopdirection = false;
                        ixend = this.pad;
                        continue;
                    }
                    ixend = this.sector_size + this.pad;
                    this.ix[0] = this.ix[0] - this.looplen;
                    continue;
                }
                if (this.ibuffer_order != this.loopdirection) {
                    this.reverseBuffers();
                }
                bak_ix = this.ix[0];
                bak_ox = ox[0];
                bak_pitch = current_pitch[0];
                for (i = 0; i < this.nrofchannels; ++i) {
                    if (buffer[i] == null) continue;
                    this.ix[0] = bak_ix;
                    ox[0] = bak_ox;
                    current_pitch[0] = bak_pitch;
                    SoftAbstractResampler.this.interpolate(this.ibuffer[i], this.ix, ixend, current_pitch, pitchstep, buffer[i], ox, ox_end);
                }
                if (!this.eof) continue;
                current_pitch[0] = this.target_pitch;
                return ox[0] - offset;
            }
            current_pitch[0] = this.target_pitch;
            return len;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }
    }
}

