/*
 * Decompiled with CFR 0.152.
 */
package cn.sherlock.com.sun.media.sound;

import cn.sherlock.com.sun.media.sound.AudioFloatConverter;
import cn.sherlock.com.sun.media.sound.AudioFloatInputStream;
import cn.sherlock.com.sun.media.sound.SoftAbstractResampler;
import cn.sherlock.com.sun.media.sound.SoftCubicResampler;
import cn.sherlock.com.sun.media.sound.SoftLanczosResampler;
import cn.sherlock.com.sun.media.sound.SoftLinearResampler;
import cn.sherlock.com.sun.media.sound.SoftLinearResampler2;
import cn.sherlock.com.sun.media.sound.SoftPointResampler;
import cn.sherlock.com.sun.media.sound.SoftSincResampler;
import cn.sherlock.javax.sound.sampled.AudioFormat;
import cn.sherlock.javax.sound.sampled.AudioInputStream;
import cn.sherlock.javax.sound.sampled.spi.FormatConversionProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class AudioFloatFormatConverter
extends FormatConversionProvider {
    private AudioFormat.Encoding[] formats = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED, AudioFloatConverter.PCM_FLOAT};

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream sourceStream) {
        if (sourceStream.getFormat().getEncoding().equals(targetEncoding)) {
            return sourceStream;
        }
        AudioFormat format = sourceStream.getFormat();
        int channels = format.getChannels();
        AudioFormat.Encoding encoding = targetEncoding;
        float samplerate = format.getSampleRate();
        int bits = format.getSampleSizeInBits();
        boolean bigendian = format.isBigEndian();
        if (targetEncoding.equals(AudioFloatConverter.PCM_FLOAT)) {
            bits = 32;
        }
        AudioFormat targetFormat = new AudioFormat(encoding, samplerate, bits, channels, channels * bits / 8, samplerate, bigendian);
        return this.getAudioInputStream(targetFormat, sourceStream);
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        if (!this.isConversionSupported(targetFormat, sourceStream.getFormat())) {
            throw new IllegalArgumentException("Unsupported conversion: " + sourceStream.getFormat().toString() + " to " + targetFormat.toString());
        }
        return this.getAudioInputStream(targetFormat, AudioFloatInputStream.getInputStream(sourceStream));
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioFloatInputStream sourceStream) {
        if (!this.isConversionSupported(targetFormat, sourceStream.getFormat())) {
            throw new IllegalArgumentException("Unsupported conversion: " + sourceStream.getFormat().toString() + " to " + targetFormat.toString());
        }
        if (targetFormat.getChannels() != sourceStream.getFormat().getChannels()) {
            sourceStream = new AudioFloatInputStreamChannelMixer(sourceStream, targetFormat.getChannels());
        }
        if ((double)Math.abs(targetFormat.getSampleRate() - sourceStream.getFormat().getSampleRate()) > 1.0E-6) {
            sourceStream = new AudioFloatInputStreamResampler(sourceStream, targetFormat);
        }
        return new AudioInputStream(new AudioFloatFormatConverterInputStream(targetFormat, sourceStream), targetFormat, sourceStream.getFrameLength());
    }

    @Override
    public AudioFormat.Encoding[] getSourceEncodings() {
        return new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED, AudioFloatConverter.PCM_FLOAT};
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings() {
        return new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED, AudioFloatConverter.PCM_FLOAT};
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        if (AudioFloatConverter.getConverter(sourceFormat) == null) {
            return new AudioFormat.Encoding[0];
        }
        return new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED, AudioFloatConverter.PCM_FLOAT};
    }

    @Override
    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        if (AudioFloatConverter.getConverter(sourceFormat) == null) {
            return new AudioFormat[0];
        }
        int channels = sourceFormat.getChannels();
        ArrayList<AudioFormat> formats = new ArrayList<AudioFormat>();
        if (targetEncoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            formats.add(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, channels, channels, -1.0f, false));
        }
        if (targetEncoding.equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            formats.add(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, channels, channels, -1.0f, false));
        }
        for (int bits = 16; bits < 32; bits += 8) {
            if (targetEncoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
                formats.add(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, bits, channels, channels * bits / 8, -1.0f, false));
                formats.add(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, bits, channels, channels * bits / 8, -1.0f, true));
            }
            if (!targetEncoding.equals(AudioFormat.Encoding.PCM_UNSIGNED)) continue;
            formats.add(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, bits, channels, channels * bits / 8, -1.0f, true));
            formats.add(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, bits, channels, channels * bits / 8, -1.0f, false));
        }
        if (targetEncoding.equals(AudioFloatConverter.PCM_FLOAT)) {
            formats.add(new AudioFormat(AudioFloatConverter.PCM_FLOAT, -1.0f, 32, channels, channels * 4, -1.0f, false));
            formats.add(new AudioFormat(AudioFloatConverter.PCM_FLOAT, -1.0f, 32, channels, channels * 4, -1.0f, true));
            formats.add(new AudioFormat(AudioFloatConverter.PCM_FLOAT, -1.0f, 64, channels, channels * 8, -1.0f, false));
            formats.add(new AudioFormat(AudioFloatConverter.PCM_FLOAT, -1.0f, 64, channels, channels * 8, -1.0f, true));
        }
        return formats.toArray(new AudioFormat[formats.size()]);
    }

    @Override
    public boolean isConversionSupported(AudioFormat targetFormat, AudioFormat sourceFormat) {
        if (AudioFloatConverter.getConverter(sourceFormat) == null) {
            return false;
        }
        if (AudioFloatConverter.getConverter(targetFormat) == null) {
            return false;
        }
        if (sourceFormat.getChannels() <= 0) {
            return false;
        }
        return targetFormat.getChannels() > 0;
    }

    @Override
    public boolean isConversionSupported(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        if (AudioFloatConverter.getConverter(sourceFormat) == null) {
            return false;
        }
        for (int i = 0; i < this.formats.length; ++i) {
            if (!targetEncoding.equals(this.formats[i])) continue;
            return true;
        }
        return false;
    }

    private static class AudioFloatInputStreamChannelMixer
    extends AudioFloatInputStream {
        private int targetChannels;
        private int sourceChannels;
        private AudioFloatInputStream ais;
        private AudioFormat targetFormat;
        private float[] conversion_buffer;

        public AudioFloatInputStreamChannelMixer(AudioFloatInputStream ais, int targetChannels) {
            this.sourceChannels = ais.getFormat().getChannels();
            this.targetChannels = targetChannels;
            this.ais = ais;
            AudioFormat format = ais.getFormat();
            this.targetFormat = new AudioFormat(format.getEncoding(), format.getSampleRate(), format.getSampleSizeInBits(), targetChannels, format.getFrameSize() / this.sourceChannels * targetChannels, format.getFrameRate(), format.isBigEndian());
        }

        @Override
        public int available() throws IOException {
            return this.ais.available() / this.sourceChannels * this.targetChannels;
        }

        @Override
        public void close() throws IOException {
            this.ais.close();
        }

        @Override
        public AudioFormat getFormat() {
            return this.targetFormat;
        }

        @Override
        public long getFrameLength() {
            return this.ais.getFrameLength();
        }

        @Override
        public void mark(int readlimit) {
            this.ais.mark(readlimit / this.targetChannels * this.sourceChannels);
        }

        @Override
        public boolean markSupported() {
            return this.ais.markSupported();
        }

        @Override
        public int read(float[] b, int off, int len) throws IOException {
            int ret;
            int len2 = len / this.targetChannels * this.sourceChannels;
            if (this.conversion_buffer == null || this.conversion_buffer.length < len2) {
                this.conversion_buffer = new float[len2];
            }
            if ((ret = this.ais.read(this.conversion_buffer, 0, len2)) < 0) {
                return ret;
            }
            if (this.sourceChannels == 1) {
                int cs = this.targetChannels;
                for (int c = 0; c < this.targetChannels; ++c) {
                    int i = 0;
                    int ix = off + c;
                    while (i < len2) {
                        b[ix] = this.conversion_buffer[i];
                        ++i;
                        ix += cs;
                    }
                }
            } else if (this.targetChannels == 1) {
                int i;
                int ix;
                int cs = this.sourceChannels;
                int i2 = 0;
                int ix2 = off;
                while (i2 < len2) {
                    b[ix2] = this.conversion_buffer[i2];
                    i2 += cs;
                    ++ix2;
                }
                for (int c = 1; c < this.sourceChannels; ++c) {
                    ix = off;
                    for (i = c; i < len2; i += cs) {
                        int n = ix++;
                        b[n] = b[n] + this.conversion_buffer[i];
                    }
                }
                float vol = 1.0f / (float)this.sourceChannels;
                ix = off;
                for (i = 0; i < len2; i += cs) {
                    int n = ix++;
                    b[n] = b[n] * vol;
                }
            } else {
                int i;
                int c;
                int minChannels = Math.min(this.sourceChannels, this.targetChannels);
                int off_len = off + len;
                int ct = this.targetChannels;
                int cs = this.sourceChannels;
                for (c = 0; c < minChannels; ++c) {
                    i = off + c;
                    int ix = c;
                    while (i < off_len) {
                        b[i] = this.conversion_buffer[ix];
                        i += ct;
                        ix += cs;
                    }
                }
                for (c = minChannels; c < this.targetChannels; ++c) {
                    for (i = off + c; i < off_len; i += ct) {
                        b[i] = 0.0f;
                    }
                }
            }
            return ret / this.sourceChannels * this.targetChannels;
        }

        @Override
        public void reset() throws IOException {
            this.ais.reset();
        }

        @Override
        public long skip(long len) throws IOException {
            long ret = this.ais.skip(len / (long)this.targetChannels * (long)this.sourceChannels);
            if (ret < 0L) {
                return ret;
            }
            return ret / (long)this.sourceChannels * (long)this.targetChannels;
        }
    }

    private static class AudioFloatInputStreamResampler
    extends AudioFloatInputStream {
        private AudioFloatInputStream ais;
        private AudioFormat targetFormat;
        private float[] skipbuffer;
        private SoftAbstractResampler resampler;
        private float[] pitch = new float[1];
        private float[] ibuffer2;
        private float[][] ibuffer;
        private float ibuffer_index = 0.0f;
        private int ibuffer_len = 0;
        private int nrofchannels = 0;
        private float[][] cbuffer;
        private int buffer_len = 512;
        private int pad;
        private int pad2;
        private float[] ix = new float[1];
        private int[] ox = new int[1];
        private float[][] mark_ibuffer = null;
        private float mark_ibuffer_index = 0.0f;
        private int mark_ibuffer_len = 0;

        public AudioFloatInputStreamResampler(AudioFloatInputStream ais, AudioFormat format) {
            this.ais = ais;
            AudioFormat sourceFormat = ais.getFormat();
            this.targetFormat = new AudioFormat(sourceFormat.getEncoding(), format.getSampleRate(), sourceFormat.getSampleSizeInBits(), sourceFormat.getChannels(), sourceFormat.getFrameSize(), format.getSampleRate(), sourceFormat.isBigEndian());
            this.nrofchannels = this.targetFormat.getChannels();
            Object interpolation = format.getProperty("interpolation");
            if (interpolation != null && interpolation instanceof String) {
                String resamplerType = (String)interpolation;
                if (resamplerType.equalsIgnoreCase("point")) {
                    this.resampler = new SoftPointResampler();
                }
                if (resamplerType.equalsIgnoreCase("linear")) {
                    this.resampler = new SoftLinearResampler2();
                }
                if (resamplerType.equalsIgnoreCase("linear1")) {
                    this.resampler = new SoftLinearResampler();
                }
                if (resamplerType.equalsIgnoreCase("linear2")) {
                    this.resampler = new SoftLinearResampler2();
                }
                if (resamplerType.equalsIgnoreCase("cubic")) {
                    this.resampler = new SoftCubicResampler();
                }
                if (resamplerType.equalsIgnoreCase("lanczos")) {
                    this.resampler = new SoftLanczosResampler();
                }
                if (resamplerType.equalsIgnoreCase("sinc")) {
                    this.resampler = new SoftSincResampler();
                }
            }
            if (this.resampler == null) {
                this.resampler = new SoftLinearResampler2();
            }
            this.pitch[0] = sourceFormat.getSampleRate() / format.getSampleRate();
            this.pad = this.resampler.getPadding();
            this.pad2 = this.pad * 2;
            this.ibuffer = new float[this.nrofchannels][this.buffer_len + this.pad2];
            this.ibuffer2 = new float[this.nrofchannels * this.buffer_len];
            this.ibuffer_index = this.buffer_len + this.pad;
            this.ibuffer_len = this.buffer_len;
        }

        @Override
        public int available() throws IOException {
            return 0;
        }

        @Override
        public void close() throws IOException {
            this.ais.close();
        }

        @Override
        public AudioFormat getFormat() {
            return this.targetFormat;
        }

        @Override
        public long getFrameLength() {
            return -1L;
        }

        @Override
        public void mark(int readlimit) {
            this.ais.mark((int)((float)readlimit * this.pitch[0]));
            this.mark_ibuffer_index = this.ibuffer_index;
            this.mark_ibuffer_len = this.ibuffer_len;
            if (this.mark_ibuffer == null) {
                this.mark_ibuffer = new float[this.ibuffer.length][this.ibuffer[0].length];
            }
            for (int c = 0; c < this.ibuffer.length; ++c) {
                float[] from = this.ibuffer[c];
                float[] to = this.mark_ibuffer[c];
                for (int i = 0; i < to.length; ++i) {
                    to[i] = from[i];
                }
            }
        }

        @Override
        public boolean markSupported() {
            return this.ais.markSupported();
        }

        private void readNextBuffer() throws IOException {
            int ix;
            int i;
            if (this.ibuffer_len == -1) {
                return;
            }
            for (int c = 0; c < this.nrofchannels; ++c) {
                float[] buff = this.ibuffer[c];
                int buffer_len_pad = this.ibuffer_len + this.pad2;
                i = this.ibuffer_len;
                ix = 0;
                while (i < buffer_len_pad) {
                    buff[ix] = buff[i];
                    ++i;
                    ++ix;
                }
            }
            this.ibuffer_index -= (float)this.ibuffer_len;
            this.ibuffer_len = this.ais.read(this.ibuffer2);
            if (this.ibuffer_len >= 0) {
                int ret;
                while (this.ibuffer_len < this.ibuffer2.length && (ret = this.ais.read(this.ibuffer2, this.ibuffer_len, this.ibuffer2.length - this.ibuffer_len)) != -1) {
                    this.ibuffer_len += ret;
                }
                Arrays.fill(this.ibuffer2, this.ibuffer_len, this.ibuffer2.length, 0.0f);
                this.ibuffer_len /= this.nrofchannels;
            } else {
                Arrays.fill(this.ibuffer2, 0, this.ibuffer2.length, 0.0f);
            }
            int ibuffer2_len = this.ibuffer2.length;
            for (int c = 0; c < this.nrofchannels; ++c) {
                float[] buff = this.ibuffer[c];
                i = c;
                ix = this.pad2;
                while (i < ibuffer2_len) {
                    buff[ix] = this.ibuffer2[i];
                    i += this.nrofchannels;
                    ++ix;
                }
            }
        }

        @Override
        public int read(float[] b, int off, int len) throws IOException {
            float[] buff;
            int remain;
            int preDestPos;
            if (this.cbuffer == null || this.cbuffer[0].length < len / this.nrofchannels) {
                this.cbuffer = new float[this.nrofchannels][len / this.nrofchannels];
            }
            if (this.ibuffer_len == -1) {
                return -1;
            }
            if (len < 0) {
                return 0;
            }
            int offlen = off + len;
            int destPos = 0;
            int in_end = this.ibuffer_len;
            for (remain = len / this.nrofchannels; remain > 0; remain -= destPos - preDestPos) {
                if (this.ibuffer_len >= 0) {
                    if (this.ibuffer_index >= (float)(this.ibuffer_len + this.pad)) {
                        this.readNextBuffer();
                    }
                    in_end = this.ibuffer_len + this.pad;
                }
                if (this.ibuffer_len < 0 && this.ibuffer_index >= (float)(in_end = this.pad2) || this.ibuffer_index < 0.0f) break;
                preDestPos = destPos;
                for (int c = 0; c < this.nrofchannels; ++c) {
                    this.ix[0] = this.ibuffer_index;
                    this.ox[0] = destPos;
                    buff = this.ibuffer[c];
                    this.resampler.interpolate(buff, this.ix, in_end, this.pitch, 0.0f, this.cbuffer[c], this.ox, len / this.nrofchannels);
                }
                this.ibuffer_index = this.ix[0];
                destPos = this.ox[0];
            }
            for (int c = 0; c < this.nrofchannels; ++c) {
                int ix = 0;
                buff = this.cbuffer[c];
                for (int i = c + off; i < offlen; i += this.nrofchannels) {
                    b[i] = buff[ix++];
                }
            }
            return len - remain * this.nrofchannels;
        }

        @Override
        public void reset() throws IOException {
            this.ais.reset();
            if (this.mark_ibuffer == null) {
                return;
            }
            this.ibuffer_index = this.mark_ibuffer_index;
            this.ibuffer_len = this.mark_ibuffer_len;
            for (int c = 0; c < this.ibuffer.length; ++c) {
                float[] from = this.mark_ibuffer[c];
                float[] to = this.ibuffer[c];
                for (int i = 0; i < to.length; ++i) {
                    to[i] = from[i];
                }
            }
        }

        @Override
        public long skip(long len) throws IOException {
            long remain;
            int ret;
            if (len < 0L) {
                return 0L;
            }
            if (this.skipbuffer == null) {
                this.skipbuffer = new float[1024 * this.targetFormat.getFrameSize()];
            }
            float[] l_skipbuffer = this.skipbuffer;
            for (remain = len; remain > 0L; remain -= (long)ret) {
                ret = this.read(l_skipbuffer, 0, (int)Math.min(remain, (long)this.skipbuffer.length));
                if (ret >= 0) continue;
                if (remain != len) break;
                return ret;
            }
            return len - remain;
        }
    }

    private static class AudioFloatFormatConverterInputStream
    extends InputStream {
        private AudioFloatConverter converter;
        private AudioFloatInputStream stream;
        private float[] readfloatbuffer;
        private int fsize = 0;

        public AudioFloatFormatConverterInputStream(AudioFormat targetFormat, AudioFloatInputStream stream) {
            this.stream = stream;
            this.converter = AudioFloatConverter.getConverter(targetFormat);
            this.fsize = (targetFormat.getSampleSizeInBits() + 7) / 8;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int ret = this.read(b);
            if (ret < 0) {
                return ret;
            }
            return b[0] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int ret;
            int flen = len / this.fsize;
            if (this.readfloatbuffer == null || this.readfloatbuffer.length < flen) {
                this.readfloatbuffer = new float[flen];
            }
            if ((ret = this.stream.read(this.readfloatbuffer, 0, flen)) < 0) {
                return ret;
            }
            this.converter.toByteArray(this.readfloatbuffer, 0, ret, b, off);
            return ret * this.fsize;
        }

        @Override
        public int available() throws IOException {
            int ret = this.stream.available();
            if (ret < 0) {
                return ret;
            }
            return ret * this.fsize;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.stream.mark(readlimit * this.fsize);
        }

        @Override
        public boolean markSupported() {
            return this.stream.markSupported();
        }

        @Override
        public synchronized void reset() throws IOException {
            this.stream.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            long ret = this.stream.skip(n / (long)this.fsize);
            if (ret < 0L) {
                return ret;
            }
            return ret * (long)this.fsize;
        }
    }
}

