<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "6e626bef5ed78a1cc55b0dbf44f01d47",
  "translation_date": "2025-10-15T02:24:14+00:00",
  "source_file": "getting_started/troubleshooting.md",
  "language_code": "ur"
}
-->
# مائیکروسافٹ کو-آپ مترجم ٹربل شوٹنگ گائیڈ

## جائزہ
مائیکروسافٹ کو-آپ مترجم ایک طاقتور ٹول ہے جو مارک ڈاؤن دستاویزات کو بغیر کسی رکاوٹ کے ترجمہ کرنے کی سہولت دیتا ہے۔ یہ گائیڈ اس ٹول کو استعمال کرتے وقت پیش آنے والے عام مسائل کو حل کرنے میں آپ کی مدد کرے گی۔

## عام مسائل اور ان کے حل

### 1. مارک ڈاؤن ٹیگ کا مسئلہ
مسئلہ: ترجمہ شدہ مارک ڈاؤن دستاویز کے اوپر `markdown` ٹیگ شامل ہے، جس سے رینڈرنگ میں مسئلہ آ رہا ہے۔

حل: اس مسئلے کو حل کرنے کے لیے، فائل کے اوپر موجود `markdown` ٹیگ کو حذف کر دیں۔ اس سے مارک ڈاؤن فائل درست طریقے سے رینڈر ہو گی۔

طریقہ کار:
1. ترجمہ شدہ مارک ڈاؤن (`.md`) فائل کھولیں۔
2. دستاویز کے اوپر `markdown` ٹیگ تلاش کریں۔
3. `markdown` ٹیگ کو حذف کر دیں۔
4. فائل کو محفوظ کریں۔
5. فائل دوبارہ کھول کر تصدیق کریں کہ وہ درست رینڈر ہو رہی ہے۔

### 2. ایمبیڈڈ امیجز کے یو آر ایل کا مسئلہ
مسئلہ: ایمبیڈڈ امیجز کے یو آر ایل زبان کے لوکیل سے میل نہیں کھاتے، جس سے غلط یا غائب تصاویر آ رہی ہیں۔

حل: ایمبیڈڈ امیجز کے یو آر ایل چیک کریں اور تصدیق کریں کہ وہ زبان کے لوکیل سے میل کھاتے ہیں۔ تمام تصاویر `translated_images` فولڈر میں موجود ہیں اور ہر تصویر کے فائل نام میں زبان کا لوکیل ٹیگ شامل ہے۔

طریقہ کار:
1. ترجمہ شدہ مارک ڈاؤن دستاویز کھولیں۔
2. ایمبیڈڈ امیجز اور ان کے یو آر ایل شناخت کریں۔
3. تصدیق کریں کہ تصویر کے فائل نام میں زبان کا لوکیل دستاویز کی زبان سے میل کھاتا ہے۔
4. اگر ضرورت ہو تو یو آر ایل اپ ڈیٹ کریں۔
5. تبدیلیاں محفوظ کریں اور دستاویز دوبارہ کھول کر تصدیق کریں کہ تصاویر درست رینڈر ہو رہی ہیں۔

### 3. ترجمے کی درستگی
مسئلہ: ترجمہ شدہ مواد درست نہیں یا مزید ایڈیٹنگ کی ضرورت ہے۔

حل: ترجمہ شدہ دستاویز کا جائزہ لیں اور درستگی اور پڑھنے میں بہتری کے لیے ضروری ترامیم کریں۔

طریقہ کار:
1. ترجمہ شدہ دستاویز کھولیں۔
2. مواد کو بغور پڑھیں۔
3. ترجمے کی درستگی کے لیے ضروری ترامیم کریں۔
4. تبدیلیاں محفوظ کریں۔

## 4. پرمیشن ایرر ریڈیکٹڈ یا 404

اگر تصاویر یا متن درست زبان میں ترجمہ نہیں ہو رہا اور -d ڈیبگ موڈ میں 401 ایرر آ رہا ہے۔ یہ کلاسک آتھنٹیکیشن فیلئر ہے—یا تو کی غلط، ایکسپائرڈ یا اینڈ پوائنٹ کے ریجن سے لنکڈ نہیں۔

کو-آپ مترجم کو [-d debug switch](https://github.com/Azure/co-op-translator/blob/main/getting_started/command-reference.md) کے ساتھ چلائیں تاکہ اصل وجہ معلوم ہو سکے۔

- ایرر میسج: `Access denied due to invalid subscription key or wrong API endpoint.`
- ممکنہ وجوہات:
  - سبسکرپشن کی درخواست میں ریڈیکٹڈ یا غلط ہے۔
  - AI Services Key یا Subscription Key کسی اور Azure ریسورس (جیسے Translator یا OpenAI) کی ہے، نہ کہ **Azure AI Vision** ریسورس کی۔

 **ریسورس ٹائپ**
  - [Azure Portal](https://portal.azure.com) یا [Azure AI Foundry](https://ai.azure.com) پر جائیں اور تصدیق کریں کہ ریسورس کا ٹائپ `Azure AI services` → `Vision` ہے۔
  - کیز کی تصدیق کریں اور درست کی استعمال کریں۔

## 5. کنفیگریشن ایررز (نیا ایرر ہینڈلنگ)

نئے سیلیکٹو ترجمہ سسٹم کے ساتھ، کو-آپ مترجم اب واضح ایرر میسجز فراہم کرتا ہے جب ضروری سروسز کنفیگر نہ ہوں۔

### 5.1. امیج ترجمہ کے لیے Azure AI سروس کنفیگر نہیں

مسئلہ: آپ نے امیج ترجمہ (`-img` فلیگ) کی درخواست کی ہے لیکن Azure AI سروس درست طریقے سے کنفیگر نہیں۔

ایرر میسج:
```
Error: Image translation requested but Azure AI Service is not configured.
Please add AZURE_AI_SERVICE_API_KEY and AZURE_AI_SERVICE_ENDPOINT to your .env file.
Check Azure AI Service availability and configuration.
```

حل:
1. آپشن 1: Azure AI سروس کنفیگر کریں
   - اپنی `.env` فائل میں `AZURE_AI_SERVICE_API_KEY` شامل کریں
   - اپنی `.env` فائل میں `AZURE_AI_SERVICE_ENDPOINT` شامل کریں
   - تصدیق کریں کہ سروس قابل رسائی ہے

2. آپشن 2: امیج ترجمہ کی درخواست ہٹا دیں
   ```bash
   # Instead of: translate -l "ko" -img
   # Use: translate -l "ko" -md
   ```

### 5.2. ضروری کنفیگریشن غائب

مسئلہ: لازمی LLM کنفیگریشن غائب ہے۔

ایرر میسج:
```
Error: No language model configuration found.
Please configure either Azure OpenAI or OpenAI in your .env file.
```

حل:
1. تصدیق کریں کہ آپ کی `.env` فائل میں کم از کم ان میں سے ایک LLM کنفیگریشن موجود ہے:
   - Azure OpenAI: `AZURE_OPENAI_API_KEY` اور `AZURE_OPENAI_ENDPOINT`
   - OpenAI: `OPENAI_API_KEY`
   
   آپ کو یا تو Azure OpenAI یا OpenAI کنفیگر کرنا ہے، دونوں نہیں۔

### 5.3. سیلیکٹو ترجمہ میں کنفیوژن

مسئلہ: کوئی فائل ترجمہ نہیں ہوئی حالانکہ کمانڈ کامیاب رہی۔

ممکنہ وجوہات:
- غلط فائل ٹائپ فلیگز (`-md`, `-img`, `-nb`)
- پروجیکٹ میں کوئی میچنگ فائل نہیں
- ڈائریکٹری اسٹرکچر غلط

حل:
1. ڈیبگ موڈ استعمال کریں تاکہ معلوم ہو سکے کیا ہو رہا ہے:
   ```bash
   translate -l "ko" -md -d
   ```

2. اپنے پروجیکٹ میں فائل ٹائپس چیک کریں:
   ```bash
   # For markdown files
   find . -name "*.md" -not -path "./translations/*"
   
   # For notebooks
   find . -name "*.ipynb" -not -path "./translations/*"
   
   # For images
   find . -name "*.png" -o -name "*.jpg" -o -name "*.jpeg" -not -path "./translations/*"
   ```

3. فلیگ کمبینیشنز کی تصدیق کریں:
   ```bash
   # Translate everything (default)
   translate -l "ko"
   
   # Translate specific types
   translate -l "ko" -md -img
   ```

## 6. پرانے سسٹم سے مائیگریشن

### 6.1. صرف مارک ڈاؤن موڈ ختم

مسئلہ: وہ کمانڈز جو خودکار مارک ڈاؤن-صرف بیک اپ پر انحصار کرتی تھیں اب توقع کے مطابق کام نہیں کرتیں۔

پرانا رویہ:
```bash
# This used to automatically switch to markdown-only mode
translate -l "ko"  # (when Azure AI Vision was not configured)
```

نیا رویہ:
```bash
# This now produces an error if image translation is requested but not configured
translate -l "ko" -img
```

حل:
- واضح طور پر بتائیں کہ آپ کیا ترجمہ کرنا چاہتے ہیں:
  ```bash
  translate -l "ko" -md        # Only markdown
  translate -l "ko" -md -img   # Markdown and images
  translate -l "ko"            # Everything (if all services configured)
  ```

### 6.2. غیر متوقع لنک رویہ

مسئلہ: ترجمہ شدہ فائلوں میں لنکس غیر متوقع جگہوں کی طرف اشارہ کرتے ہیں۔

وجہ: منتخب کردہ فائل ٹائپس کی بنیاد پر ڈائنامک لنک پروسیسنگ بدل جاتی ہے۔

حل:
1. نئے لنک رویے کو سمجھیں:
   - `-nb` شامل: نوٹ بک لنکس ترجمہ شدہ ورژنز کی طرف اشارہ کرتے ہیں
   - `-nb` خارج: نوٹ بک لنکس اصل فائلوں کی طرف اشارہ کرتے ہیں
   - `-img` شامل: امیج لنکس ترجمہ شدہ ورژنز کی طرف اشارہ کرتے ہیں
   - `-img` خارج: امیج لنکس اصل فائلوں کی طرف اشارہ کرتے ہیں

2. اپنے استعمال کے مطابق درست کمبینیشن منتخب کریں:
   ```bash
   # All internal links point to translated versions
   translate -l "ko" -md -img -nb
   
   # Only markdown translated, other links point to originals
   translate -l "ko" -md
   ```

## 7. GitHub ایکشن چلا لیکن کوئی پل ریکویسٹ (PR) نہیں بنی

علامت: `peter-evans/create-pull-request` کے ورک فلو لاگز میں یہ پیغام آتا ہے:

> برانچ 'update-translations' بیس 'main' سے آگے نہیں ہے اور نہیں بنے گی

ممکنہ وجوہات:
- کوئی تبدیلی نہیں ملی: ترجمہ والے مرحلے نے کوئی فرق پیدا نہیں کیا (ریپو پہلے ہی اپ ٹو ڈیٹ ہے)۔
- آؤٹ پٹس کو نظر انداز کیا گیا: `.gitignore` ان فائلوں کو نظر انداز کر رہا ہے جنہیں آپ کمیٹ کرنا چاہتے ہیں (مثلاً `*.ipynb`, `translations/`, `translated_images/`)۔
- add-paths میل نہیں کھاتا: ایکشن کو دیے گئے راستے اصل آؤٹ پٹ لوکیشنز سے میل نہیں کھاتے۔
- ورک فلو لاجک/شرائط: ترجمہ والا مرحلہ جلدی ختم ہو گیا یا غیر متوقع ڈائریکٹریز میں لکھا گیا۔

کیسے درست کریں / تصدیق کریں:
1. آؤٹ پٹس کی موجودگی کی تصدیق کریں: ترجمہ کے بعد، ورک اسپیس میں `translations/` اور/یا `translated_images/` میں نئی/تبدیل شدہ فائلیں چیک کریں۔
   - اگر نوٹ بکس ترجمہ کر رہے ہیں تو تصدیق کریں کہ `.ipynb` فائلیں واقعی `translations/<lang>/...` میں لکھی گئی ہیں۔
2. `.gitignore` کا جائزہ لیں: تیار شدہ آؤٹ پٹس کو نظر انداز نہ کریں۔ تصدیق کریں کہ آپ ان کو نظر انداز نہیں کر رہے:
   - `translations/`
   - `translated_images/`
   - `*.ipynb` (اگر نوٹ بکس ترجمہ کر رہے ہیں)
3. add-paths آؤٹ پٹس سے میل کھاتا ہو: ملٹی لائن ویلیو استعمال کریں اور دونوں فولڈرز شامل کریں اگر ضرورت ہو:
   ```yaml
   with:
     add-paths: |
       translations/
       translated_images/
   ```
4. ڈیبگنگ کے لیے عارضی طور پر خالی کمیٹس کی اجازت دیں تاکہ وائرنگ درست ہو:
   ```yaml
   with:
     commit-empty: true
   ```
5. ڈیبگ کے ساتھ چلائیں: ترجمہ کمانڈ میں `-d` شامل کریں تاکہ معلوم ہو سکے کون سی فائلیں دریافت اور لکھی گئیں۔
6. پرمیشنز (GITHUB_TOKEN): تصدیق کریں کہ ورک فلو کے پاس کمیٹس اور PR بنانے کے لیے رائٹ پرمیشنز ہیں:
   ```yaml
   permissions:
     contents: write
     pull-requests: write
   ```


## فوری ڈیبگنگ چیک لسٹ

جب ترجمہ کے مسائل حل کر رہے ہوں:

1. ڈیبگ موڈ استعمال کریں: تفصیلی لاگز کے لیے `-d` فلیگ شامل کریں
2. اپنے فلیگز چیک کریں: تصدیق کریں کہ `-md`, `-img`, `-nb` آپ کی نیت کے مطابق ہیں
3. کنفیگریشن کی تصدیق کریں: اپنی `.env` فائل میں ضروری کیز چیک کریں
4. مرحلہ وار ٹیسٹ کریں: صرف `-md` سے شروع کریں، پھر دیگر ٹائپس شامل کریں
5. فائل اسٹرکچر چیک کریں: تصدیق کریں کہ سورس فائلیں موجود اور قابل رسائی ہیں

مزید تفصیلی معلومات کے لیے دستیاب کمانڈز اور فلیگز کے بارے میں، [کمانڈ ریفرنس](./command-reference.md) دیکھیں۔

---

**اعلانِ دستبرداری**:
یہ دستاویز AI ترجمہ سروس [Co-op Translator](https://github.com/Azure/co-op-translator) کے ذریعے ترجمہ کی گئی ہے۔ اگرچہ ہم درستگی کی کوشش کرتے ہیں، براہ کرم آگاہ رہیں کہ خودکار ترجمے میں غلطیاں یا عدم درستگی ہو سکتی ہے۔ اصل دستاویز اپنی اصل زبان میں مستند ماخذ سمجھی جائے۔ اہم معلومات کے لیے پیشہ ور انسانی ترجمہ کی سفارش کی جاتی ہے۔ اس ترجمے کے استعمال سے پیدا ہونے والی کسی بھی غلط فہمی یا غلط تشریح کی صورت میں ہم ذمہ دار نہیں ہیں۔