<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "20943a46b11c6d74814f41a817a6db4c",
  "translation_date": "2025-10-15T02:24:49+00:00",
  "source_file": "getting_started/command-line-guide/translator-your-project.md",
  "language_code": "ur"
}
-->
# اپنے پروجیکٹ کا ترجمہ Co-op Translator کے ذریعے کریں

**Co-op Translator** ایک کمانڈ لائن انٹرفیس (CLI) ٹول ہے جو آپ کو اپنے پروجیکٹ میں موجود مارک ڈاؤن اور امیج فائلز کو مختلف زبانوں میں ترجمہ کرنے میں مدد دیتا ہے۔ اس سیکشن میں اس ٹول کے استعمال کا طریقہ، مختلف CLI آپشنز کی وضاحت اور مختلف استعمال کی مثالیں دی گئی ہیں۔

---

## مثالیں اور کمانڈز

یہاں **Co-op Translator** کے چند عام استعمالات اور ان کے مطابق چلائی جانے والی کمانڈز دی گئی ہیں۔

### 1. بنیادی ترجمہ (ایک زبان میں)

اگر آپ اپنے پورے پروجیکٹ (مارک ڈاؤن فائلز اور امیجز) کو کسی ایک زبان، جیسے کوریائی میں ترجمہ کرنا چاہتے ہیں تو یہ کمانڈ استعمال کریں:

```bash
translate -l "ko"
```

یہ کمانڈ تمام مارک ڈاؤن اور امیج فائلز کو کوریائی میں ترجمہ کرے گی اور نئے ترجمے شامل کرے گی، بغیر اس کے کہ پہلے سے موجود ترجمے ڈیلیٹ ہوں۔

#### Phi-3 CookBook پر مثال

**Phi-3 CookBook** میں، میں نے موجودہ مارک ڈاؤن فائلز اور امیجز کے لیے کوریائی ترجمہ شامل کرنے کے لیے یہ طریقہ استعمال کیا۔

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko"
Translating images: 100%|███████████████████████████████████████████████████| 276/276 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 153/153 [1:43:07<00:00, 241.31s/it]
```

### 2. ایک سے زیادہ زبانوں میں ترجمہ

اگر آپ اپنے پروجیکٹ کو ایک سے زیادہ زبانوں (مثلاً ہسپانوی، فرانسیسی اور جرمن) میں ترجمہ کرنا چاہتے ہیں تو یہ کمانڈ استعمال کریں:

```bash
translate -l "es fr de"
```

یہ کمانڈ پروجیکٹ کو ہسپانوی، فرانسیسی اور جرمن میں ترجمہ کرے گی اور نئے ترجمے شامل کرے گی، بغیر اس کے کہ پہلے سے موجود ترجمے اوور رائٹ ہوں۔

#### Phi-3 CookBook پر مثال

**Phi-3 CookBook** میں، تازہ ترین تبدیلیاں حاصل کرنے کے بعد، میں نے نئے شامل ہونے والے مارک ڈاؤن فائلز اور امیجز کو ترجمہ کرنے کے لیے یہ طریقہ استعمال کیا۔

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko ja zh tw es fr" -a
Translating images: 100%|███████████████████████████████████████████████████| 273/273 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 6/6 [24:07<00:00, 241.31s/it]
```

### 3. ترجمے اپ ڈیٹ کرنا (پرانے ترجمے ڈیلیٹ ہو جائیں گے)

اگر آپ موجودہ ترجمے اپ ڈیٹ کرنا چاہتے ہیں (یعنی موجودہ ترجمے ڈیلیٹ کر کے نئے ترجمے شامل کرنا)، تو `-u` آپشن استعمال کریں۔ اس سے مخصوص زبانوں کے تمام موجودہ ترجمے ڈیلیٹ ہو جائیں گے اور دوبارہ ترجمہ ہو گا۔

```bash
translate -l "ko" -u
```

خبردار: یہ کمانڈ آپ سے تصدیق مانگے گی اس سے پہلے کہ موجودہ ترجمے ڈیلیٹ کیے جائیں۔

#### Phi-3 CookBook پر مثال

**Phi-3 CookBook** میں، میں نے ہسپانوی میں تمام ترجمہ شدہ فائلز کو اپ ڈیٹ کرنے کے لیے یہ طریقہ استعمال کیا۔ میں یہ طریقہ اس وقت تجویز کرتا ہوں جب اصل مواد میں کئی مارک ڈاؤن ڈاکیومنٹس میں بڑی تبدیلیاں کی گئی ہوں۔ اگر صرف چند ترجمہ شدہ مارک ڈاؤن فائلز کو اپ ڈیٹ کرنا ہو تو بہتر ہے کہ وہ مخصوص فائلز خود ڈیلیٹ کریں اور پھر `-a` طریقہ استعمال کر کے اپ ڈیٹڈ ترجمے شامل کریں۔

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "es" -u
Warning: The update command will delete all existing translations for 'es' and re-translate everything.
Do you want to continue? Type 'yes' to proceed: yes
Proceeding with update...
Translating images: 100%|████████████████████████████████████████████| 150/150 [43:46<00:00, 15.55s/it]
Translating markdown files: 100%|███████████████████████████████████| 95/95 [1:40:27<00:00, 125.62s/it]
```

### 5. صرف امیجز کا ترجمہ

اگر آپ اپنے پروجیکٹ میں صرف امیج فائلز کا ترجمہ کرنا چاہتے ہیں تو `-img` آپشن استعمال کریں:

```bash
translate -l "ko" -img
```

یہ کمانڈ صرف امیجز کو کوریائی میں ترجمہ کرے گی، مارک ڈاؤن فائلز پر کوئی اثر نہیں ہو گا۔

### 6. صرف مارک ڈاؤن فائلز کا ترجمہ

اگر آپ اپنے پروجیکٹ میں صرف مارک ڈاؤن فائلز کا ترجمہ کرنا چاہتے ہیں تو `-md` آپشن استعمال کریں:

```bash
translate -l "ko" -md
```

#### Phi-3 CookBook پر مثال

**Phi-3 CookBook** میں، میں نے کوریائی فائلز میں ترجمے کی غلطیاں چیک کرنے اور جن فائلز میں مسئلہ ہو ان کے لیے خودکار طور پر دوبارہ ترجمہ کرنے کے لیے یہ طریقہ استعمال کیا۔

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko" -chk 
Checking translated files for errors in ko...
Checking files for ko: 100%|██████████████████████████████████████████████████| 95/95 [00:01<00:00, 65.47file/s]
Retrying vsc-extension-quickstart.md for ko:   0%|                                     | 0/17 [00:00<?, ?file/s] 
```

یہ آپشن ترجمے کی غلطیاں چیک کرتا ہے۔ اس وقت اگر اصل اور ترجمہ شدہ فائلز میں لائن بریکس کا فرق چھ سے زیادہ ہو تو فائل کو ترجمے کی غلطی کے طور پر نشان زد کیا جاتا ہے۔ میں مستقبل میں اس معیار کو مزید لچکدار بنانے کا ارادہ رکھتا ہوں۔

مثال کے طور پر، یہ طریقہ ان فائلز میں گمشدہ حصے یا خراب ترجمے تلاش کرنے کے لیے مفید ہے، اور ان فائلز کے لیے خودکار طور پر دوبارہ ترجمہ کرے گا۔

تاہم، اگر آپ کو پہلے سے معلوم ہے کہ کون سی فائلز میں مسئلہ ہے تو بہتر ہے کہ وہ فائلز خود ڈیلیٹ کریں اور `-a` آپشن استعمال کر کے دوبارہ ترجمہ کریں۔

### 8. ڈیبگ موڈ

اگر آپ کو ترجمے کے دوران مسائل کی تشخیص کے لیے تفصیلی لاگنگ چاہیے تو `-d` آپشن استعمال کریں:

```bash
translate -l "ko" -d
```

یہ کمانڈ ترجمہ ڈیبگ موڈ میں چلائے گی اور اضافی لاگنگ معلومات فراہم کرے گی جو ترجمے کے عمل میں مسائل کی نشاندہی میں مدد دے سکتی ہے۔

#### Phi-3 CookBook پر مثال

**Phi-3 CookBook** میں، مجھے ایک مسئلہ پیش آیا جہاں مارک ڈاؤن فائلز میں زیادہ لنکس ہونے کی وجہ سے ترجمے میں فارمیٹنگ کی غلطیاں آ رہی تھیں، جیسے ترجمہ ٹوٹ جانا یا لائن بریکس نظر انداز ہونا۔ اس مسئلے کی تشخیص کے لیے میں نے `-d` آپشن استعمال کیا تاکہ دیکھ سکوں ترجمے کا عمل کیسے ہو رہا ہے۔

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "ko" -d
DEBUG:openai._base_client:Request options: {'method': 'post', 'url': '/chat/completions', 'headers': {'api-key': 'af04e0bea45747d8a7b8c131c1971044'}, 'files': None, 'json_data': {'messages': [{'role': 'user', 'content': "Translate the following text to ko. NEVER ADD ANY EXTRA CONTENT OUTSIDE THE TRANSLATION. TRANSLATE ONLY WHAT IS GIVEN TO YOU.. MAINTAIN MARKDOWN FORMAT\n\n# Phi-3 Cookbook: Hands-On Examples with Microsoft's Phi-3 Models [![Open and use the samples in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/microsoft/phi-3cookbook) [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%
...
```

### 9. تمام زبانوں میں ترجمہ

اگر آپ پروجیکٹ کو تمام سپورٹڈ زبانوں میں ترجمہ کرنا چاہتے ہیں تو all کی ورڈ استعمال کریں۔

```bash
translate -l "all"
```

یہ کمانڈ پروجیکٹ کو تمام دستیاب زبانوں میں ترجمہ کرے گی۔ اگر آپ آگے بڑھتے ہیں تو ترجمہ پروجیکٹ کے سائز کے حساب سے کافی وقت لے سکتا ہے۔

> ### ترجمہ شدہ فائلز کو دستی طور پر ڈیلیٹ کرنا (اختیاری)
> ترجمہ شدہ فائلز اب خودکار طور پر ڈیٹیکٹ اور کلین اپ ہو جاتی ہیں جب سورس فائل اپ ڈیٹ ہو۔
>
> تاہم، اگر آپ کسی ترجمے کو دستی طور پر اپ ڈیٹ کرنا چاہتے ہیں - مثلاً کسی مخصوص فائل کو دوبارہ کرنا یا سسٹم کے رویے کو اوور رائیڈ کرنا - تو آپ درج ذیل کمانڈ استعمال کر کے اس فائل کے تمام ورژنز کو زبانوں کے فولڈرز سے ڈیلیٹ کر سکتے ہیں۔
>
> ### ونڈوز پر:
> 1. **کمانڈ پرامپٹ استعمال کرتے ہوئے**:
>    - کمانڈ پرامپٹ کھولیں۔
>    - `cd` کمانڈ کے ذریعے اس فولڈر میں جائیں جہاں فائلز موجود ہیں۔
>    - فائلز ڈیلیٹ کرنے کے لیے یہ کمانڈ استعمال کریں:
>      ```
>      del /s *filename*
>      ```
>      `filename` کو اس فائل کے نام کے حصے سے بدلیں جسے آپ تلاش کر رہے ہیں۔ `/s` آپشن سب ڈائریکٹریز میں بھی تلاش کرے گا۔
>
> 2. **پاور شیل استعمال کرتے ہوئے**:
>    - پاور شیل کھولیں۔
>    - یہ کمانڈ چلائیں:
>      ```powershell
>      Get-ChildItem -Path "C:\YourPath" -Filter "*filename*" -Recurse | Remove-Item -Force
>      ```
>      `"C:\YourPath"` کو فولڈر کے راستے اور `filename` کو مخصوص نام سے بدلیں۔
>
> ### میک او ایس/لینکس پر:
> 1. **ٹرمینل استعمال کرتے ہوئے**:
>   - ٹرمینل کھولیں۔
>   - `cd` کے ذریعے ڈائریکٹری میں جائیں۔
>   - `find` کمانڈ استعمال کریں:
>     ```bash
>     find . -type f -name "*filename*" -delete
>     ```
>     `filename` کو مخصوص نام سے بدلیں۔
>
> ہمیشہ فائلز ڈیلیٹ کرنے سے پہلے اچھی طرح چیک کر لیں تاکہ غلطی سے کوئی ضروری فائل نہ ڈیلیٹ ہو جائے۔
>
> جب آپ نے وہ فائلز ڈیلیٹ کر دیں جنہیں ری پلیس کرنا ہے تو بس اپنی `translate -l` کمانڈ دوبارہ چلائیں تاکہ تازہ ترین تبدیلیاں اپ ڈیٹ ہو جائیں۔

---

**اعلانِ دستبرداری**:
یہ دستاویز AI ترجمہ سروس [Co-op Translator](https://github.com/Azure/co-op-translator) کے ذریعے ترجمہ کی گئی ہے۔ اگرچہ ہم درستگی کی کوشش کرتے ہیں، براہ کرم آگاہ رہیں کہ خودکار ترجمے میں غلطیاں یا عدم درستگی ہو سکتی ہے۔ اصل دستاویز اپنی مقامی زبان میں مستند ماخذ سمجھی جائے۔ اہم معلومات کے لیے پیشہ ور انسانی ترجمہ کی سفارش کی جاتی ہے۔ اس ترجمے کے استعمال سے پیدا ہونے والی کسی بھی غلط فہمی یا غلط تشریح کی صورت میں ہم ذمہ دار نہیں ہیں۔