<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "510827ad22a2031a50838919c3594828",
  "translation_date": "2025-10-15T02:24:40+00:00",
  "source_file": "getting_started/command-line-guide/install-package.md",
  "language_code": "ur"
}
-->
# کو-آپ ٹرانسلیٹر پیکیج انسٹال کریں

**کو-آپ ٹرانسلیٹر** ایک کمانڈ لائن انٹرفیس (CLI) ٹول ہے جو آپ کے پروجیکٹ کی تمام مارک ڈاؤن فائلز اور تصاویر کو مختلف زبانوں میں ترجمہ کرنے میں مدد دیتا ہے۔ یہ ٹیوٹوریل آپ کو ٹرانسلیٹر کو کنفیگر کرنے اور مختلف استعمالات کے لیے چلانے کے طریقے کی رہنمائی کرے گا۔

### ورچوئل انوائرمنٹ بنائیں

آپ `pip` یا `Poetry` میں سے کسی ایک کا استعمال کرتے ہوئے ورچوئل انوائرمنٹ بنا سکتے ہیں۔ اپنی ٹرمینل میں مندرجہ ذیل میں سے کوئی ایک کمانڈ لکھیں۔

#### pip کا استعمال کرتے ہوئے

```bash
python -m venv .venv
```

#### Poetry کا استعمال کرتے ہوئے

```bash
poetry init
```

### ورچوئل انوائرمنٹ کو ایکٹیویٹ کریں

ورچوئل انوائرمنٹ بنانے کے بعد، آپ کو اسے ایکٹیویٹ کرنا ہوگا۔ یہ مرحلے آپریٹنگ سسٹم کے حساب سے مختلف ہیں۔ اپنی ٹرمینل میں مندرجہ ذیل کمانڈ لکھیں۔

#### pip اور Poetry دونوں کے لیے

- ونڈوز:

    ```bash
    .venv\Scripts\activate
    ```

- میک/لینکس:

    ```bash
    source .venv/bin/activate
    ```

#### Poetry کا استعمال کرتے ہوئے

1. اگر آپ نے انوائرمنٹ Poetry سے بنایا ہے تو اسے ایکٹیویٹ کرنے کے لیے اپنی ٹرمینل میں مندرجہ ذیل کمانڈ لکھیں۔

    ```bash
    poetry shell
    ```

### پیکیج اور ضروری پیکیجز انسٹال کرنا

جب آپ کا ورچوئل انوائرمنٹ سیٹ اپ اور ایکٹیویٹ ہو جائے، تو اگلا مرحلہ ضروری ڈیپینڈنسیز انسٹال کرنا ہے۔

### فوری انسٹالیشن

Co-Op Translator کو pip کے ذریعے انسٹال کریں

```
pip install co-op-translator
```
یا

poetry کے ذریعے انسٹال کریں
```
poetry add co-op-translator
```

#### pip کا استعمال کرتے ہوئے (requirements.txt سے) اگر آپ نے یہ ریپو کلون کیا ہے

> [!NOTE]
> براہ کرم یہ مت کریں اگر آپ نے کو-آپ ٹرانسلیٹر کو فوری انسٹالیشن کے ذریعے انسٹال کیا ہے۔

1. اگر آپ pip استعمال کر رہے ہیں تو اپنی ٹرمینل میں مندرجہ ذیل کمانڈ لکھیں۔ یہ خود بخود `requirements.txt` فائل میں دی گئی ضروری پیکیجز انسٹال کر دے گا:

    ```bash
    pip install -r requirements.txt
    ```

#### Poetry کا استعمال کرتے ہوئے (pyproject.toml سے)

1. اگر آپ Poetry استعمال کر رہے ہیں تو اپنی ٹرمینل میں مندرجہ ذیل کمانڈ لکھیں۔ یہ خود بخود `pyproject.toml` فائل میں دی گئی ضروری پیکیجز انسٹال کر دے گا:

    ```bash
    poetry install
    ```

---

**اعلانِ دستبرداری**:
یہ دستاویز AI ترجمہ سروس [Co-op Translator](https://github.com/Azure/co-op-translator) کے ذریعے ترجمہ کی گئی ہے۔ اگرچہ ہم درستگی کی کوشش کرتے ہیں، براہ کرم آگاہ رہیں کہ خودکار ترجمے میں غلطیاں یا عدم درستگی ہو سکتی ہے۔ اصل دستاویز اپنی اصل زبان میں مستند ذریعہ سمجھی جائے۔ اہم معلومات کے لیے پیشہ ور انسانی ترجمہ کی سفارش کی جاتی ہے۔ اس ترجمے کے استعمال سے پیدا ہونے والی کسی بھی غلط فہمی یا غلط تشریح کی صورت میں ہم ذمہ دار نہیں ہیں۔