<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "dac6bc281667816537df51f724a0ff2c",
  "translation_date": "2025-11-30T10:04:23+00:00",
  "source_file": "README.md",
  "language_code": "ur"
}
-->
# کو-آپ مترجم

_اپنے تعلیمی GitHub مواد کا ترجمہ آسانی سے خودکار طریقے سے متعدد زبانوں میں کریں تاکہ عالمی سامعین تک پہنچ سکیں۔_

[![Python package](https://img.shields.io/pypi/v/co-op-translator?color=4BA3FF)](https://pypi.org/project/co-op-translator/)
[![License: MIT](https://img.shields.io/github/license/azure/co-op-translator?color=4BA3FF)](https://github.com/azure/co-op-translator/blob/main/LICENSE)
[![Downloads](https://static.pepy.tech/badge/co-op-translator)](https://pepy.tech/project/co-op-translator)
[![Downloads](https://static.pepy.tech/badge/co-op-translator/month)](https://pepy.tech/project/co-op-translator)
[![Container: GHCR](https://img.shields.io/badge/Container-GHCR-2496ED?logo=docker&logoColor=fff)](https://github.com/azure/co-op-translator/pkgs/container/co-op-translator)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

[![GitHub contributors](https://img.shields.io/github/contributors/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/graphs/contributors/)
[![GitHub issues](https://img.shields.io/github/issues/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/issues/)
[![GitHub pull-requests](https://img.shields.io/github/issues-pr/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/pulls/)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](http://makeapullrequest.com)

### 🌐 کثیراللسانی معاونت

#### [Co-op Translator](https://github.com/Azure/Co-op-Translator) کی جانب سے معاونت یافتہ

<!-- CO-OP TRANSLATOR LANGUAGES TABLE START -->
[عربی](../ar/README.md) | [بنگالی](../bn/README.md) | [بلغاریائی](../bg/README.md) | [برمی (میانمار)](../my/README.md) | [چینی (سادہ)](../zh/README.md) | [چینی (روایتی، ہانگ کانگ)](../hk/README.md) | [چینی (روایتی، مکاو)](../mo/README.md) | [چینی (روایتی، تائیوان)](../tw/README.md) | [کروشین](../hr/README.md) | [چیک](../cs/README.md) | [ڈینش](../da/README.md) | [ڈچ](../nl/README.md) | [ایسٹونین](../et/README.md) | [فنش](../fi/README.md) | [فرانسیسی](../fr/README.md) | [جرمن](../de/README.md) | [یونانی](../el/README.md) | [عبرانی](../he/README.md) | [ہندی](../hi/README.md) | [ہنگیرین](../hu/README.md) | [انڈونیشین](../id/README.md) | [اطالوی](../it/README.md) | [جاپانی](../ja/README.md) | [کنڑ](../kn/README.md) | [کوریائی](../ko/README.md) | [لتھوانین](../lt/README.md) | [ملائی](../ms/README.md) | [ملایالم](../ml/README.md) | [مراٹھی](../mr/README.md) | [نیپالی](../ne/README.md) | [نائجیریائی پیجین](../pcm/README.md) | [ناروے](../no/README.md) | [فارسی (فارس)](../fa/README.md) | [پولش](../pl/README.md) | [پرتگالی (برازیل)](../br/README.md) | [پرتگالی (پرتگال)](../pt/README.md) | [پنجابی (گرمکھی)](../pa/README.md) | [رومانیائی](../ro/README.md) | [روسی](../ru/README.md) | [سربیائی (سریلیک)](../sr/README.md) | [سلوواک](../sk/README.md) | [سلووینیائی](../sl/README.md) | [ہسپانوی](../es/README.md) | [سواحلی](../sw/README.md) | [سویڈش](../sv/README.md) | [ٹاگالوگ (فلپائنی)](../tl/README.md) | [تمل](../ta/README.md) | [تیلگو](../te/README.md) | [تھائی](../th/README.md) | [ترکی](../tr/README.md) | [یوکرینیائی](../uk/README.md) | [اردو](./README.md) | [ویتنامی](../vi/README.md)
<!-- CO-OP TRANSLATOR LANGUAGES TABLE END -->

[![GitHub watchers](https://img.shields.io/github/watchers/azure/co-op-translator.svg?style=social&label=Watch)](https://GitHub.com/azure/co-op-translator/watchers/)
[![GitHub forks](https://img.shields.io/github/forks/azure/co-op-translator.svg?style=social&label=Fork)](https://GitHub.com/azure/co-op-translator/network/)
[![GitHub stars](https://img.shields.io/github/stars/azure/co-op-translator?style=social&label=Star)](https://GitHub.com/azure/co-op-translator/stargazers/)

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

[![Open in GitHub Codespaces](https://img.shields.io/static/v1?style=for-the-badge&label=Github%20Codespaces&message=Open&color=24292F&logo=github)](https://codespaces.new/azure/co-op-translator)

## جائزہ

**کو-آپ مترجم** آپ کے تعلیمی GitHub مواد کو آسانی سے متعدد زبانوں میں مقامی بنانے میں مدد دیتا ہے۔  
جب آپ اپنے مارک ڈاؤن فائلز، تصاویر، یا نوٹ بکس کو اپ ڈیٹ کرتے ہیں، تو ترجمے خود بخود ہم آہنگ رہتے ہیں، تاکہ آپ کا مواد دنیا بھر کے سیکھنے والوں کے لیے درست اور تازہ ترین رہے۔

ترجمہ شدہ مواد کی تنظیم کی مثال:

![Example](../../translated_images/translation-ex.0c8aa6a7ee0aad2b35cddcc110c719baf0afc640e8c5a45540e6c166b9907d91.ur.png)

## جلدی آغاز

```bash
# ایک ورچوئل ماحول بنائیں اور فعال کریں (تجویز کردہ)
python -m venv .venv
# ونڈوز
.venv\Scripts\activate
# میک او ایس/لینکس
source .venv/bin/activate
# پیکیج انسٹال کریں
pip install co-op-translator
# ترجمہ کریں
translate -l "ko ja fr" -md
```
  
ڈوکر:

```bash
# GHCR سے پبلک امیج کھینچیں
docker pull ghcr.io/azure/co-op-translator:latest
# موجودہ فولڈر کو ماؤنٹ کر کے اور .env فراہم کر کے چلائیں (Bash/Zsh)
docker run --rm -it --env-file .env -v "${PWD}:/work" ghcr.io/azure/co-op-translator:latest -l "ko ja fr" -md
```
  
## کم از کم سیٹ اپ

1. `.env` فائل بنائیں ٹیمپلیٹ استعمال کرتے ہوئے: [.env.template](../../.env.template)  
2. ایک LLM فراہم کنندہ ترتیب دیں (Azure OpenAI یا OpenAI)  
3. (اختیاری) تصویر کے ترجمے کے لیے (`-img`)، Azure AI Vision ترتیب دیں  
4. (تجویز کردہ) پچھلے ترجمے صاف کریں تاکہ تصادم نہ ہو (مثلاً `translations/`)  
5. (تجویز کردہ) اپنے README میں ترجمے کا سیکشن شامل کریں [README languages template](./getting_started/README_languages_template.md) استعمال کرتے ہوئے  
6. دیکھیں: [Azure AI سیٹ اپ کریں](./getting_started/set-up-azure-ai.md)

## استعمال

تمام معاون اقسام کا ترجمہ کریں:

```bash
translate -l "ko ja"
```
  
صرف مارک ڈاؤن:

```bash
translate -l "de" -md
```
  
مارک ڈاؤن + تصاویر:

```bash
translate -l "pt" -md -img
```
  
صرف نوٹ بکس:

```bash
translate -l "zh" -nb
```
  
مزید جھنڈے: [کمانڈ حوالہ](./getting_started/command-reference.md)

## خصوصیات

- مارک ڈاؤن، نوٹ بکس، اور تصاویر کے لیے خودکار ترجمہ  
- ماخذ میں تبدیلیوں کے ساتھ ترجمے کو ہم آہنگ رکھتا ہے  
- مقامی (CLI) یا CI (GitHub Actions) میں کام کرتا ہے  
- Azure OpenAI یا OpenAI استعمال کرتا ہے؛ تصاویر کے لیے اختیاری Azure AI Vision  
- مارک ڈاؤن کی فارمیٹنگ اور ساخت کو برقرار رکھتا ہے

## دستاویزات

- [کمانڈ لائن گائیڈ](./getting_started/command-line-guide/command-line-guide.md)  
- [GitHub Actions گائیڈ (عوامی ریپوزٹریز اور معیاری سیکریٹس)](./getting_started/github-actions-guide/github-actions-guide-public.md)  
- [GitHub Actions گائیڈ (Microsoft تنظیمی ریپوزٹریز اور تنظیمی سطح کی ترتیبات)](./getting_started/github-actions-guide/github-actions-guide-org.md)  
- [README زبانوں کا ٹیمپلیٹ](./getting_started/README_languages_template.md)  
- [معاون زبانیں](./getting_started/supported-languages.md)  
- [شراکت داری](./CONTRIBUTING.md)  
- [مسائل کا حل](./getting_started/troubleshooting.md)

### مائیکروسافٹ مخصوص گائیڈ
> [!NOTE]
> صرف Microsoft “For Beginners” ریپوزٹریز کے مینٹینرز کے لیے۔

- [“دیگر کورسز” کی فہرست کو اپ ڈیٹ کرنا (صرف MS Beginners ریپوزٹریز کے لیے)](./getting_started/update-other-courses.md)

## ہمارا ساتھ دیں اور عالمی تعلیم کو فروغ دیں

تعلیمی مواد کے عالمی اشتراک میں انقلاب لانے میں ہمارا ساتھ دیں! [Co-op Translator](https://github.com/azure/co-op-translator) کو GitHub پر ⭐ دیں اور زبان کی رکاوٹوں کو ختم کرنے کے ہمارے مشن کی حمایت کریں۔ آپ کی دلچسپی اور تعاون بہت اہم ہے! کوڈ میں شراکت اور فیچر تجاویز ہمیشہ خوش آمدید ہیں۔

### اپنی زبان میں Microsoft تعلیمی مواد دریافت کریں

- [AZD for Beginners](https://github.com/microsoft/AZD-for-beginners)  
- [Edge AI for Beginners](https://github.com/microsoft/edgeai-for-beginners)  
- [Model Context Protocol (MCP) For Beginners](https://github.com/microsoft/mcp-for-beginners)  
- [AI Agents for Beginners](https://github.com/microsoft/ai-agents-for-beginners)  
- [Generative AI for Beginners using .NET](https://github.com/microsoft/Generative-AI-for-beginners-dotnet)  
- [Generative AI for Beginners](https://github.com/microsoft/generative-ai-for-beginners)  
- [Generative AI for Beginners using Java](https://github.com/microsoft/generative-ai-for-beginners-java)  
- [ML for Beginners](https://aka.ms/ml-beginners)  
- [Data Science for Beginners](https://aka.ms/datascience-beginners)  
- [AI for Beginners](https://aka.ms/ai-beginners)  
- [Cybersecurity for Beginners](https://github.com/microsoft/Security-101)  
- [Web Dev for Beginners](https://aka.ms/webdev-beginners)  
- [IoT for Beginners](https://aka.ms/iot-beginners)  
- [PhiCookBook](https://github.com/microsoft/PhiCookBook)

## ویڈیو پریزنٹیشنز

👉 نیچے تصویر پر کلک کریں تاکہ YouTube پر دیکھ سکیں۔

- **Open at Microsoft**: کو-آپ مترجم کے استعمال کا مختصر 18 منٹ کا تعارف اور فوری رہنمائی۔

  [![Open at Microsoft](../../translated_images/open-ms-thumbnail.946b356b89bc5f0e33dcebb852f7926b98c33f54c1a49ce01c36ae7f35e2443a.ur.jpg)](https://www.youtube.com/watch?v=jX_swfH_KNU)

## شراکت داری

یہ پروجیکٹ تعاون اور تجاویز کا خیرمقدم کرتا ہے۔ Azure Co-op Translator میں حصہ لینے کے خواہشمند ہیں؟ براہ کرم ہمارے [CONTRIBUTING.md](./CONTRIBUTING.md) کو دیکھیں تاکہ جان سکیں کہ آپ کو-آپ مترجم کو مزید قابل رسائی بنانے میں کیسے مدد کر سکتے ہیں۔

## شراکت دار

[![co-op-translator contributors](https://contrib.rocks/image?repo=Azure/co-op-translator)](https://github.com/Azure/co-op-translator/graphs/contributors)

## ضابطہ اخلاق

اس پروجیکٹ نے [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/) کو اپنایا ہے۔  
مزید معلومات کے لیے [Code of Conduct FAQ](https://opensource.microsoft.com/codeofconduct/faq/) دیکھیں یا  
کسی بھی اضافی سوالات یا تبصروں کے لیے [opencode@microsoft.com](mailto:opencode@microsoft.com) سے رابطہ کریں۔

## ذمہ دار AI

مائیکروسافٹ اپنے صارفین کی مدد کے لیے پرعزم ہے کہ وہ ہمارے AI مصنوعات کو ذمہ داری سے استعمال کریں، اپنے تجربات شیئر کریں، اور شفافیت نوٹس اور اثرات کے جائزوں جیسے اوزار کے ذریعے اعتماد پر مبنی شراکت داری قائم کریں۔ ان میں سے بہت سے وسائل [https://aka.ms/RAI](https://aka.ms/RAI) پر دستیاب ہیں۔  
مائیکروسافٹ کا ذمہ دار AI کا طریقہ کار ہمارے AI اصولوں پر مبنی ہے: انصاف، اعتبار اور حفاظت، پرائیویسی اور سیکیورٹی، شمولیت، شفافیت، اور جوابدہی۔

بڑے پیمانے پر قدرتی زبان، تصویر، اور تقریر کے ماڈلز — جیسے کہ اس نمونے میں استعمال ہونے والے — ممکنہ طور پر غیر منصفانہ، غیر قابل اعتماد، یا توہین آمیز رویہ اختیار کر سکتے ہیں، جو نقصان کا باعث بن سکتے ہیں۔ براہ کرم خطرات اور حدود کے بارے میں آگاہی کے لیے [Azure OpenAI service Transparency note](https://learn.microsoft.com/legal/cognitive-services/openai/transparency-note?tabs=text) ملاحظہ کریں۔
ان خطرات کو کم کرنے کے لیے تجویز کردہ طریقہ یہ ہے کہ آپ اپنی ساخت میں ایک حفاظتی نظام شامل کریں جو نقصان دہ رویے کا پتہ لگا سکے اور اسے روک سکے۔ [Azure AI Content Safety](https://learn.microsoft.com/azure/ai-services/content-safety/overview) ایک آزاد حفاظتی پرت فراہم کرتا ہے، جو ایپلیکیشنز اور خدمات میں نقصان دہ صارف اور AI کی تخلیق کردہ مواد کا پتہ لگا سکتا ہے۔ Azure AI Content Safety میں متن اور تصویر کے API شامل ہیں جو آپ کو نقصان دہ مواد کا پتہ لگانے کی اجازت دیتے ہیں۔ ہمارے پاس ایک انٹرایکٹو Content Safety Studio بھی ہے جو آپ کو مختلف طریقوں سے نقصان دہ مواد کا پتہ لگانے کے لیے نمونہ کوڈ دیکھنے، دریافت کرنے اور آزمانے کی سہولت دیتا ہے۔ درج ذیل [quickstart دستاویزات](https://learn.microsoft.com/azure/ai-services/content-safety/quickstart-text?tabs=visual-studio%2Clinux&pivots=programming-language-rest) آپ کو سروس کو درخواستیں بھیجنے کے عمل میں رہنمائی کرتی ہیں۔

ایک اور پہلو جسے مدنظر رکھنا ضروری ہے وہ مجموعی ایپلیکیشن کی کارکردگی ہے۔ کثیر النوع اور کثیر ماڈل ایپلیکیشنز کے ساتھ، ہم کارکردگی کو اس طرح سمجھتے ہیں کہ نظام آپ اور آپ کے صارفین کی توقعات کے مطابق کام کرے، جس میں نقصان دہ نتائج پیدا نہ کرنا بھی شامل ہے۔ اپنے مجموعی ایپلیکیشن کی کارکردگی کا جائزہ لینا ضروری ہے، جس کے لیے آپ [generation quality اور risk and safety metrics](https://learn.microsoft.com/azure/ai-studio/concepts/evaluation-metrics-built-in) استعمال کر سکتے ہیں۔

آپ اپنے AI ایپلیکیشن کا جائزہ اپنے ترقیاتی ماحول میں [prompt flow SDK](https://microsoft.github.io/promptflow/index.html) کے ذریعے لے سکتے ہیں۔ چاہے آپ کے پاس ٹیسٹ ڈیٹا سیٹ ہو یا کوئی ہدف، آپ کی جنریٹو AI ایپلیکیشن کی تخلیقات کو بلٹ ان یا اپنی مرضی کے مطابق ایویلیویٹرز کے ذریعے مقداری طور پر ماپا جاتا ہے۔ اپنے نظام کا جائزہ لینے کے لیے prompt flow SDK کے ساتھ شروع کرنے کے لیے، آپ [quickstart guide](https://learn.microsoft.com/azure/ai-studio/how-to/develop/flow-evaluate-sdk) پر عمل کر سکتے ہیں۔ ایک بار جب آپ جائزہ چلائیں، تو آپ [Azure AI Studio میں نتائج کو دیکھ سکتے ہیں](https://learn.microsoft.com/azure/ai-studio/how-to/evaluate-flow-results)۔

## ٹریڈ مارکس

یہ پروجیکٹ پروجیکٹس، مصنوعات، یا خدمات کے ٹریڈ مارکس یا لوگوز پر مشتمل ہو سکتا ہے۔ Microsoft کے ٹریڈ مارکس یا لوگوز کا مجاز استعمال [Microsoft کے Trademark & Brand Guidelines](https://www.microsoft.com/en-us/legal/intellectualproperty/trademarks/usage/general) کے تابع ہے اور ان کی پیروی کرنا ضروری ہے۔ اس پروجیکٹ کے ترمیم شدہ ورژنز میں Microsoft کے ٹریڈ مارکس یا لوگوز کا استعمال الجھن پیدا نہیں کرنا چاہیے اور نہ ہی Microsoft کی سرپرستی کا تاثر دینا چاہیے۔ کسی بھی تیسرے فریق کے ٹریڈ مارکس یا لوگوز کا استعمال ان فریقوں کی پالیسیوں کے تابع ہے۔

## مدد حاصل کرنا

اگر آپ پھنس جائیں یا AI ایپس بنانے کے بارے میں کوئی سوال ہو، تو شامل ہوں:

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

اگر آپ کے پاس مصنوعات کے بارے میں رائے ہو یا تعمیر کے دوران کوئی غلطی ہو تو یہاں جائیں:

[![Microsoft Foundry Developer Forum](https://img.shields.io/badge/GitHub-Microsoft_Foundry_Developer_Forum-blue?style=for-the-badge&logo=github&color=000000&logoColor=fff)](https://aka.ms/foundry/forum)

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**دستخطی دستبرداری**:  
یہ دستاویز AI ترجمہ سروس [Co-op Translator](https://github.com/Azure/co-op-translator) کے ذریعے ترجمہ کی گئی ہے۔ اگرچہ ہم درستگی کے لیے کوشاں ہیں، براہ کرم آگاہ رہیں کہ خودکار ترجمے میں غلطیاں یا عدم درستیاں ہو سکتی ہیں۔ اصل دستاویز اپنی مادری زبان میں ہی معتبر ماخذ سمجھی جانی چاہیے۔ اہم معلومات کے لیے پیشہ ور انسانی ترجمہ کی سفارش کی جاتی ہے۔ اس ترجمے کے استعمال سے پیدا ہونے والی کسی بھی غلط فہمی یا غلط تشریح کی ذمہ داری ہم پر عائد نہیں ہوتی۔
<!-- CO-OP TRANSLATOR DISCLAIMER END -->