<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "758ca1c5ae0d32c52d2dd59132dcfbf0",
  "translation_date": "2025-11-30T10:03:30+00:00",
  "source_file": "CONTRIBUTING.md",
  "language_code": "ur"
}
-->
# کو-آپ ٹرانسلیٹر میں تعاون

یہ پروجیکٹ تعاون اور تجاویز کا خیرمقدم کرتا ہے۔ زیادہ تر تعاون کے لیے آپ کو ایک
Contributor License Agreement (CLA) سے اتفاق کرنا ضروری ہے جو یہ ظاہر کرتا ہے کہ آپ کے پاس یہ حق ہے، اور آپ واقعی ہمیں
اپنے تعاون کے استعمال کے حقوق دیتے ہیں۔ تفصیلات کے لیے ملاحظہ کریں https://cla.opensource.microsoft.com۔

جب آپ کوئی پل ریکویسٹ جمع کرواتے ہیں، تو ایک CLA بوٹ خود بخود یہ تعین کرے گا کہ آیا آپ کو CLA فراہم کرنا ہے
اور PR کو مناسب طریقے سے نشان زد کرے گا (مثلاً، اسٹیٹس چیک، تبصرہ)۔ بس بوٹ کی ہدایات پر عمل کریں۔
آپ کو یہ صرف ایک بار تمام ریپوز میں کرنا ہوگا جو ہمارے CLA استعمال کرتے ہیں۔

## ترقیاتی ماحول کی ترتیب

اس پروجیکٹ کے لیے ترقیاتی ماحول قائم کرنے کے لیے، ہم انحصار کے انتظام کے لیے Poetry استعمال کرنے کی سفارش کرتے ہیں۔ ہم `pyproject.toml` کو پروجیکٹ انحصار کے انتظام کے لیے استعمال کرتے ہیں، لہٰذا انحصار انسٹال کرنے کے لیے آپ کو Poetry استعمال کرنا چاہیے۔

### ورچوئل ماحول بنائیں

#### pip استعمال کرتے ہوئے

```bash
python -m venv .venv
```

#### Poetry استعمال کرتے ہوئے

```bash
poetry init
```

### ورچوئل ماحول کو فعال کریں

#### pip اور Poetry دونوں کے لیے

- ونڈوز:

    ```bash
    .venv\Scripts\activate.bat
    ```

- میک/لینکس:

    ```bash
    source .venv/bin/activate
    ```

#### Poetry استعمال کرتے ہوئے

```bash
poetry shell
```

### پیکیج اور مطلوبہ پیکیجز انسٹال کرنا

#### Poetry استعمال کرتے ہوئے (pyproject.toml سے)

```bash
poetry install
```

### دستی جانچ

PR جمع کروانے سے پہلے، ترجمہ کی فعالیت کو حقیقی دستاویزات کے ساتھ جانچنا ضروری ہے:

1. روٹ ڈائریکٹری میں ایک ٹیسٹ ڈائریکٹری بنائیں:
    ```bash
    mkdir test_docs
    ```

2. کچھ مارک ڈاؤن دستاویزات اور تصاویر جو آپ ترجمہ کرنا چاہتے ہیں، ٹیسٹ ڈائریکٹری میں کاپی کریں۔ مثلاً:
    ```bash
    cp /path/to/your/docs/*.md test_docs/
    cp /path/to/your/images/*.png test_docs/
    ```

3. پیکیج کو مقامی طور پر انسٹال کریں:
    ```bash
    pip install -e .
    ```

4. اپنے ٹیسٹ دستاویزات پر Co-op Translator چلائیں:
    ```bash
    python -m co_op_translator --language-codes ko --root-dir test_docs
    ```

5. `test_docs/translations` اور `test_docs/translated_images` میں ترجمہ شدہ فائلوں کو چیک کریں تاکہ تصدیق ہو سکے کہ:
   - ترجمے کا معیار درست ہے
   - میٹا ڈیٹا تبصرے صحیح ہیں
   - اصل مارک ڈاؤن ساخت برقرار ہے
   - لنکس اور تصاویر صحیح کام کر رہی ہیں

یہ دستی جانچ یقینی بناتی ہے کہ آپ کی تبدیلیاں حقیقی دنیا کے منظرناموں میں اچھی طرح کام کرتی ہیں۔

### ماحول کے متغیرات

1. روٹ ڈائریکٹری میں `.env` فائل بنائیں، فراہم کردہ `.env.template` فائل کو کاپی کر کے۔
1. ماحول کے متغیرات کو ہدایات کے مطابق پر کریں۔

> [!TIP]
>
> ### اضافی ترقیاتی ماحول کے اختیارات
>
> پروجیکٹ کو مقامی طور پر چلانے کے علاوہ، آپ GitHub Codespaces یا VS Code Dev Containers بھی استعمال کر سکتے ہیں تاکہ متبادل ترقیاتی ماحول قائم کیا جا سکے۔
>
> #### GitHub Codespaces
>
> آپ اس نمونہ کو GitHub Codespaces کے ذریعے ورچوئل طور پر چلا سکتے ہیں اور کسی اضافی سیٹنگ یا ترتیب کی ضرورت نہیں ہے۔
>
> یہ بٹن آپ کے براؤزر میں ویب بیسڈ VS Code انسٹینس کھولے گا:
>
> 1. ٹیمپلیٹ کھولیں (یہ چند منٹ لے سکتا ہے):
>
>     [![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/azure/co-op-translator)
>
> #### VS Code Dev Containers کے ذریعے مقامی طور پر چلانا
>
> ⚠️ یہ آپشن صرف اس صورت میں کام کرے گا جب آپ کے Docker Desktop کو کم از کم 16 GB RAM مختص کی گئی ہو۔ اگر آپ کے پاس 16 GB سے کم RAM ہے، تو آپ [GitHub Codespaces آپشن](../..) آزما سکتے ہیں یا [مقامی طور پر ترتیب دے سکتے ہیں](../..)۔
>
> ایک متعلقہ آپشن VS Code Dev Containers ہے، جو پروجیکٹ کو آپ کے مقامی VS Code میں [Dev Containers ایکسٹینشن](https://marketplace.visualstudio.com/items?itemName=ms-vscode-remote.remote-containers) کے ذریعے کھولے گا:
>
> 1. Docker Desktop شروع کریں (اگر پہلے سے انسٹال نہیں ہے تو انسٹال کریں)
> 2. پروجیکٹ کھولیں:
>
>    [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%20Containers&message=Open&color=blue&logo=visualstudiocode)](https://vscode.dev/redirect?url=vscode://ms-vscode-remote.remote-containers/cloneInVolume?url=https://github.com/azure/co-op-translator)


### کوڈ اسٹائل

ہم اپنے Python کوڈ کے لیے [Black](https://github.com/psf/black) استعمال کرتے ہیں تاکہ پروجیکٹ میں کوڈ اسٹائل یکساں رہے۔ Black ایک سخت کوڈ فارمیٹر ہے جو خود بخود Python کوڈ کو Black کوڈ اسٹائل کے مطابق دوبارہ فارمیٹ کرتا ہے۔

#### ترتیب

Black کی ترتیب ہمارے `pyproject.toml` میں دی گئی ہے:

```toml
[tool.black]
line-length = 88
target-version = ['py310']
include = '\.pyi?$'
```

#### Black انسٹال کرنا

آپ Black کو Poetry (تجویز کردہ) یا pip کے ذریعے انسٹال کر سکتے ہیں:

##### Poetry استعمال کرتے ہوئے

جب آپ ترقیاتی ماحول سیٹ اپ کرتے ہیں تو Black خود بخود انسٹال ہو جاتا ہے:
```bash
poetry install
```

##### pip استعمال کرتے ہوئے

اگر آپ pip استعمال کر رہے ہیں، تو آپ Black کو براہ راست انسٹال کر سکتے ہیں:
```bash
pip install black
```

#### Black استعمال کرنا

##### Poetry کے ساتھ

1. پروجیکٹ میں تمام Python فائلوں کو فارمیٹ کریں:
    ```bash
    poetry run black .
    ```

2. کسی مخصوص فائل یا ڈائریکٹری کو فارمیٹ کریں:
    ```bash
    poetry run black path/to/file_or_directory
    ```

##### pip کے ساتھ

1. پروجیکٹ میں تمام Python فائلوں کو فارمیٹ کریں:
    ```bash
    black .
    ```

2. کسی مخصوص فائل یا ڈائریکٹری کو فارمیٹ کریں:
    ```bash
    black path/to/file_or_directory
    ```

> [!TIP]
> ہم تجویز کرتے ہیں کہ آپ اپنے ایڈیٹر کو اس طرح ترتیب دیں کہ کوڈ کو محفوظ کرتے وقت خود بخود Black کے ساتھ فارمیٹ کرے۔ زیادہ تر جدید ایڈیٹرز اس کی حمایت ایکسٹینشنز یا پلگ انز کے ذریعے کرتے ہیں۔

## Co-op Translator چلانا

اپنے ماحول میں Poetry استعمال کرتے ہوئے Co-op Translator چلانے کے لیے، درج ذیل مراحل پر عمل کریں:

1. اس ڈائریکٹری میں جائیں جہاں آپ ترجمہ کے ٹیسٹ کرنا چاہتے ہیں یا ٹیسٹنگ کے لیے عارضی فولڈر بنائیں۔

2. درج ذیل کمانڈ چلائیں۔ `-l ko` کو اس زبان کے کوڈ سے بدلیں جس میں آپ ترجمہ کرنا چاہتے ہیں۔ `-d` فلیگ ڈیبگ موڈ کے لیے ہے۔

    ```bash
    poetry run co-op-translator translate -l ko -d
    ```

> [!NOTE]
> کمانڈ چلانے سے پہلے یقینی بنائیں کہ آپ کا Poetry ماحول فعال ہے (poetry shell)۔

## نئی زبان میں تعاون کریں

ہم نئی زبانوں کی حمایت شامل کرنے والے تعاون کا خیرمقدم کرتے ہیں۔ PR کھولنے سے پہلے، براہ کرم نیچے دیے گئے مراحل مکمل کریں تاکہ جائزہ آسانی سے ہو سکے۔

1. زبان کو فونٹ میپنگ میں شامل کریں
   - `src/co_op_translator/fonts/font_language_mappings.yml` کو ایڈٹ کریں
   - ایک اندراج شامل کریں جس میں:
     - `code`: ISO جیسا زبان کوڈ (مثلاً `vi`)
     - `name`: انسانی فہم کے لیے ڈسپلے نام
     - `font`: `src/co_op_translator/fonts/` میں شامل کوئی ایسا فونٹ جو اس رسم الخط کی حمایت کرتا ہو
     - `rtl`: اگر دائیں سے بائیں ہے تو `true` ورنہ `false`

2. مطلوبہ فونٹ فائلیں شامل کریں (اگر ضرورت ہو)
   - اگر نیا فونٹ درکار ہے، تو اوپن سورس تقسیم کے لیے لائسنس کی مطابقت کی تصدیق کریں
   - فونٹ فائل کو `src/co_op_translator/fonts/` میں شامل کریں

3. مقامی تصدیق
   - ایک چھوٹے نمونے (مارک ڈاؤن، تصاویر، اور نوٹ بکس جیسا مناسب ہو) کے لیے ترجمے چلائیں
   - آؤٹ پٹ کی درستگی کی تصدیق کریں، بشمول فونٹس اور اگر لاگو ہو تو RTL لے آؤٹ

4. دستاویزات کو اپ ڈیٹ کریں
   - یقینی بنائیں کہ زبان `getting_started/supported-languages.md` میں ظاہر ہو
   - `getting_started/README_languages_template.md` میں کوئی تبدیلی ضروری نہیں؛ یہ سپورٹڈ لسٹ سے خود تیار ہوتا ہے

5. PR کھولیں
   - شامل کی گئی زبان اور کسی فونٹ/لائسنسنگ کے پہلوؤں کی وضاحت کریں
   - اگر ممکن ہو تو رینڈر شدہ آؤٹ پٹ کے اسکرین شاٹس منسلک کریں

مثال کے طور پر YAML اندراج:

```yaml
new_lang(code):
  name: "New Language"
  font: "NotoSans-Medium.ttf"
  rtl: false
```

### نئی زبان کی جانچ کریں

آپ نئی زبان کی جانچ درج ذیل کمانڈ چلانے سے کر سکتے ہیں:

```bash
# ایک ورچوئل ماحول بنائیں اور فعال کریں
python -m venv .venv
# ونڈوز
.venv\Scripts\activate
# میک او ایس/لینکس
source .venv/bin/activate
# ترقیاتی پیکیج انسٹال کریں
pip install -e .
# ترجمہ چلائیں
translate -l "new_lang"
```

## مینٹینرز

### کمیٹ میسج اور مرج حکمت عملی

اپنے پروجیکٹ کی کمیٹ ہسٹری میں یکسانیت اور وضاحت کو یقینی بنانے کے لیے، ہم **Squash and Merge** حکمت عملی استعمال کرتے ہوئے **آخری کمیٹ میسج** کے لیے مخصوص کمیٹ میسج فارمیٹ پر عمل کرتے ہیں۔

جب کوئی پل ریکویسٹ (PR) مرج کی جاتی ہے، تو انفرادی کمیٹس کو ایک کمیٹ میں سکواش کیا جاتا ہے۔ آخری کمیٹ میسج کو نیچے دیے گئے فارمیٹ کے مطابق ہونا چاہیے تاکہ صاف اور یکساں ہسٹری برقرار رہے۔

#### کمیٹ میسج فارمیٹ (squash and merge کے لیے)

ہم کمیٹ میسجز کے لیے درج ذیل فارمیٹ استعمال کرتے ہیں:

```bash
<type>: <description> (#<PR نمبر>)
```

- **type**: کمیٹ کی قسم بتاتا ہے۔ ہم درج ذیل اقسام استعمال کرتے ہیں:
  - `Docs`: دستاویزات کی اپ ڈیٹس کے لیے۔
  - `Build`: بلڈ سسٹم یا انحصار سے متعلق تبدیلیوں کے لیے، بشمول کنفیگریشن فائلز، CI ورک فلو، یا Dockerfile کی اپ ڈیٹس۔
  - `Core`: پروجیکٹ کی بنیادی فعالیت یا خصوصیات میں تبدیلیوں کے لیے، خاص طور پر `src/co_op_translator/core` ڈائریکٹری کی فائلوں میں۔

- **description**: تبدیلی کا مختصر خلاصہ۔
- **PR number**: متعلقہ پل ریکویسٹ نمبر۔

**مثالیں**:

- `Docs: انسٹالیشن ہدایات کو واضح کیا (#50)`
- `Core: تصویر کے ترجمے کی ہینڈلنگ بہتر کی (#60)`

> [!NOTE]
> فی الحال، **`Docs`**، **`Core`**، اور **`Build`** کے پیش لفظ خود بخود PR کے عنوانات میں شامل کیے جاتے ہیں جو تبدیل شدہ سورس کوڈ پر لگائے گئے لیبلز کی بنیاد پر ہوتے ہیں۔ جب تک درست لیبل لگایا گیا ہو، آپ کو عام طور پر PR عنوان کو دستی طور پر اپ ڈیٹ کرنے کی ضرورت نہیں ہوتی۔ بس تصدیق کریں کہ سب کچھ درست ہے اور پیش لفظ مناسب طریقے سے پیدا ہوا ہے۔

#### مرج حکمت عملی

ہم پل ریکویسٹ کے لیے بطور ڈیفالٹ **Squash and Merge** حکمت عملی استعمال کرتے ہیں۔ یہ حکمت عملی یقینی بناتی ہے کہ کمیٹ میسجز ہمارے فارمیٹ کے مطابق ہوں، چاہے انفرادی کمیٹس نہ ہوں۔

**وجوہات**:

- صاف، خطی پروجیکٹ ہسٹری۔
- کمیٹ میسجز میں یکسانیت۔
- معمولی کمیٹس (مثلاً "ٹائپو درست کریں") کی وجہ سے شور میں کمی۔

مرج کرتے وقت، یقینی بنائیں کہ آخری کمیٹ میسج اوپر بیان کردہ فارمیٹ کے مطابق ہو۔

**Squash and Merge کی مثال**
اگر PR میں درج ذیل کمیٹس ہوں:

- `fix typo`
- `update README`
- `adjust formatting`

تو انہیں سکواش کر کے بنائیں:
`Docs: دستاویزات کی وضاحت اور فارمیٹنگ بہتر کی (#65)`

### ریلیز کا عمل

یہ سیکشن مینٹینرز کے لیے Co-op Translator کی نئی ریلیز شائع کرنے کا آسان طریقہ بیان کرتا ہے۔

#### 1. `pyproject.toml` میں ورژن بڑھائیں

1. اگلا ورژن نمبر طے کریں (ہم semantic versioning استعمال کرتے ہیں: `MAJOR.MINOR.PATCH`)۔
2. `pyproject.toml` میں `[tool.poetry]` کے تحت `version` فیلڈ کو اپ ڈیٹ کریں۔
3. ایک مخصوص پل ریکویسٹ کھولیں جو صرف ورژن (اور اگر موجود ہوں تو خودکار طور پر اپ ڈیٹ ہونے والی لاک/میٹا ڈیٹا فائلز) کو تبدیل کرے۔
4. جائزے کے بعد، **Squash and Merge** استعمال کریں اور یقینی بنائیں کہ آخری کمیٹ میسج اوپر بیان کردہ فارمیٹ کے مطابق ہو۔

#### 2. GitHub ریلیز بنائیں

1. GitHub ریپوزیٹری صفحہ پر جائیں اور **Releases** → **Draft a new release** کھولیں۔
2. `main` برانچ سے نیا ٹیگ بنائیں (مثلاً `v0.13.0`)۔
3. ریلیز کا عنوان اسی ورژن پر رکھیں (مثلاً `v0.13.0`)۔
4. **Generate release notes** پر کلک کریں تاکہ چینج لاگ خود بخود بھر جائے۔
5. اختیاری طور پر متن میں ترمیم کریں (مثلاً نئی زبانوں کی حمایت یا اہم تبدیلیوں کو نمایاں کرنے کے لیے)۔
6. ریلیز شائع کریں۔

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**دستخطی نوٹ**:  
یہ دستاویز AI ترجمہ سروس [Co-op Translator](https://github.com/Azure/co-op-translator) کے ذریعے ترجمہ کی گئی ہے۔ اگرچہ ہم درستگی کے لیے کوشاں ہیں، براہ کرم اس بات سے آگاہ رہیں کہ خودکار ترجمے میں غلطیاں یا عدم درستیاں ہو سکتی ہیں۔ اصل دستاویز اپنی مادری زبان میں معتبر ماخذ سمجھی جانی چاہیے۔ اہم معلومات کے لیے پیشہ ور انسانی ترجمہ کی سفارش کی جاتی ہے۔ اس ترجمے کے استعمال سے پیدا ہونے والی کسی بھی غلط فہمی یا غلط تشریح کی ذمہ داری ہم پر عائد نہیں ہوتی۔
<!-- CO-OP TRANSLATOR DISCLAIMER END -->