<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "6e626bef5ed78a1cc55b0dbf44f01d47",
  "translation_date": "2025-10-15T04:17:03+00:00",
  "source_file": "getting_started/troubleshooting.md",
  "language_code": "uk"
}
-->
# Посібник з усунення несправностей Microsoft Co-op Translator

## Огляд
Microsoft Co-Op Translator — це потужний інструмент для безшовного перекладу Markdown-документів. Цей посібник допоможе вам вирішити типові проблеми, які можуть виникати під час використання інструменту.

## Поширені проблеми та їх вирішення

### 1. Проблема з тегом Markdown
**Проблема:** У перекладеному Markdown-документі з’являється тег `markdown` на початку, що призводить до проблем з відображенням.

**Вирішення:** Просто видаліть тег `markdown` на початку файлу. Після цього файл буде коректно відображатися.

**Кроки:**
1. Відкрийте перекладений Markdown (`.md`) файл.
2. Знайдіть тег `markdown` на початку документа.
3. Видаліть цей тег.
4. Збережіть зміни у файлі.
5. Перевірте, чи файл правильно відображається.

### 2. Проблема з URL вбудованих зображень
**Проблема:** URL вбудованих зображень не відповідають мовній локалі, через що зображення відображаються некоректно або не відображаються взагалі.

**Вирішення:** Перевірте URL вбудованих зображень і переконайтеся, що вони відповідають мовній локалі. Всі зображення знаходяться у папці `translated_images`, і кожне зображення має тег локалі у назві файлу.

**Кроки:**
1. Відкрийте перекладений Markdown-документ.
2. Знайдіть вбудовані зображення та їхні URL.
3. Переконайтеся, що тег локалі у назві зображення відповідає мові документа.
4. За потреби оновіть URL.
5. Збережіть зміни та перевірте, чи зображення відображаються правильно.

### 3. Точність перекладу
**Проблема:** Перекладений контент неточний або потребує додаткового редагування.

**Вирішення:** Перегляньте перекладений документ і внесіть необхідні правки для покращення точності та читабельності.

**Кроки:**
1. Відкрийте перекладений документ.
2. Уважно перегляньте зміст.
3. Внесіть необхідні правки для покращення перекладу.
4. Збережіть зміни.

## 4. Помилка дозволу Redacted або 404

Якщо зображення або текст не перекладаються на потрібну мову, і при запуску в режимі -d debug ви отримуєте помилку 401, це класична проблема автентифікації — ключ недійсний, закінчився термін дії або не прив’язаний до регіону кінцевої точки.

Запустіть co-op translator з [ключем -d debug](https://github.com/Azure/co-op-translator/blob/main/getting_started/command-reference.md), щоб краще зрозуміти причину.

- **Текст помилки**: `Access denied due to invalid subscription key or wrong API endpoint.`
- **Можливі причини**:
  - Ключ підписки був прихований або некоректний у запиті.
  - Ключ AI Services або Subscription Key належить іншому ресурсу Azure (наприклад, Translator або OpenAI), а не **Azure AI Vision**.

 **Тип ресурсу**
  - Перейдіть у [Azure Portal](https://portal.azure.com) або [Azure AI Foundry](https://ai.azure.com) і переконайтеся, що ресурс має тип `Azure AI services` → `Vision`.
  - Перевірте ключі та переконайтеся, що використовується правильний ключ.

## 5. Помилки конфігурації (нове оброблення помилок)

З новою системою вибіркового перекладу Co-op Translator тепер надає чіткі повідомлення про помилки, якщо потрібні сервіси не налаштовані.

### 5.1. Azure AI Service не налаштовано для перекладу зображень

**Проблема:** Ви запросили переклад зображень (прапорець `-img`), але Azure AI Service налаштовано некоректно.

**Текст помилки:**
```
Error: Image translation requested but Azure AI Service is not configured.
Please add AZURE_AI_SERVICE_API_KEY and AZURE_AI_SERVICE_ENDPOINT to your .env file.
Check Azure AI Service availability and configuration.
```

**Вирішення:**
1. **Варіант 1**: Налаштуйте Azure AI Service
   - Додайте `AZURE_AI_SERVICE_API_KEY` у ваш `.env` файл
   - Додайте `AZURE_AI_SERVICE_ENDPOINT` у ваш `.env` файл
   - Переконайтеся, що сервіс доступний

2. **Варіант 2**: Вилучіть запит на переклад зображень
   ```bash
   # Instead of: translate -l "ko" -img
   # Use: translate -l "ko" -md
   ```

### 5.2. Відсутня необхідна конфігурація

**Проблема:** Відсутня важлива конфігурація LLM.

**Текст помилки:**
```
Error: No language model configuration found.
Please configure either Azure OpenAI or OpenAI in your .env file.
```

**Вирішення:**
1. Переконайтеся, що у вашому `.env` файлі є хоча б одна з наступних конфігурацій LLM:
   - **Azure OpenAI**: `AZURE_OPENAI_API_KEY` і `AZURE_OPENAI_ENDPOINT`
   - **OpenAI**: `OPENAI_API_KEY`
   
   Потрібно налаштувати або Azure OpenAI, або OpenAI, не обидва одночасно.

### 5.3. Плутанина з вибірковим перекладом

**Проблема:** Жоден файл не перекладено, хоча команда виконалася успішно.

**Можливі причини:**
- Неправильні прапорці типу файлів (`-md`, `-img`, `-nb`)
- Відсутність відповідних файлів у проєкті
- Некоректна структура директорій

**Вирішення:**
1. **Увімкніть debug-режим**, щоб побачити, що відбувається:
   ```bash
   translate -l "ko" -md -d
   ```

2. **Перевірте типи файлів** у вашому проєкті:
   ```bash
   # For markdown files
   find . -name "*.md" -not -path "./translations/*"
   
   # For notebooks
   find . -name "*.ipynb" -not -path "./translations/*"
   
   # For images
   find . -name "*.png" -o -name "*.jpg" -o -name "*.jpeg" -not -path "./translations/*"
   ```

3. **Перевірте комбінації прапорців**:
   ```bash
   # Translate everything (default)
   translate -l "ko"
   
   # Translate specific types
   translate -l "ko" -md -img
   ```

## 6. Міграція зі старої системи

### 6.1. Режим лише Markdown більше не підтримується

**Проблема:** Команди, які покладалися на автоматичний режим лише Markdown, більше не працюють як раніше.

**Стара поведінка:**
```bash
# This used to automatically switch to markdown-only mode
translate -l "ko"  # (when Azure AI Vision was not configured)
```

**Нова поведінка:**
```bash
# This now produces an error if image translation is requested but not configured
translate -l "ko" -img
```

**Вирішення:**
- **Вказуйте явно**, що саме потрібно перекласти:
  ```bash
  translate -l "ko" -md        # Only markdown
  translate -l "ko" -md -img   # Markdown and images
  translate -l "ko"            # Everything (if all services configured)
  ```

### 6.2. Неочікувана поведінка посилань

**Проблема:** Посилання у перекладених файлах ведуть у неочікувані місця.

**Причина:** Динамічна обробка посилань змінюється залежно від вибраних типів файлів.

**Вирішення:**
1. **Зрозумійте нову логіку посилань**:
   - Додано `-nb`: Посилання на ноутбуки ведуть на перекладені версії
   - Не додано `-nb`: Посилання на ноутбуки ведуть на оригінальні файли
   - Додано `-img`: Посилання на зображення ведуть на перекладені версії
   - Не додано `-img`: Посилання на зображення ведуть на оригінальні файли

2. **Виберіть правильну комбінацію** для вашого випадку:
   ```bash
   # All internal links point to translated versions
   translate -l "ko" -md -img -nb
   
   # Only markdown translated, other links point to originals
   translate -l "ko" -md
   ```

## 7. GitHub Action спрацював, але Pull Request (PR) не створено

**Симптом:** У логах workflow для `peter-evans/create-pull-request` видно:

> Branch 'update-translations' is not ahead of base 'main' and will not be created

**Ймовірні причини:**
- **Змін не виявлено:** Крок перекладу не створив різниць (репозиторій вже актуальний).
- **Вихідні файли ігноруються:** `.gitignore` виключає файли, які ви очікуєте закомітити (наприклад, `*.ipynb`, `translations/`, `translated_images/`).
- **Невідповідність add-paths:** Шляхи, передані у дію, не відповідають фактичним вихідним файлам.
- **Логіка/умови workflow:** Крок перекладу завершився раніше або записав файли у неочікувані директорії.

**Як виправити / перевірити:**
1. **Переконайтеся, що вихідні файли існують:** Після перекладу перевірте, чи з’явилися нові/змінені файли у `translations/` та/або `translated_images/`.
   - Якщо перекладаєте ноутбуки, переконайтеся, що файли `.ipynb` записані у `translations/<lang>/...`.
2. **Перевірте `.gitignore`:** Не ігноруйте згенеровані вихідні файли. Переконайтеся, що НЕ ігноруєте:
   - `translations/`
   - `translated_images/`
   - `*.ipynb` (якщо перекладаєте ноутбуки)
3. **Переконайтеся, що add-paths відповідає вихідним файлам:** Використовуйте багаторядкове значення та включайте обидві папки, якщо потрібно:
   ```yaml
   with:
     add-paths: |
       translations/
       translated_images/
   ```
4. **Примусово створіть PR для налагодження:** Тимчасово дозвольте порожні коміти, щоб перевірити правильність налаштування:
   ```yaml
   with:
     commit-empty: true
   ```
5. **Запустіть з debug:** Додайте `-d` до команди перекладу, щоб побачити, які файли були знайдені та записані.
6. **Дозволи (GITHUB_TOKEN):** Переконайтеся, що workflow має права на запис для створення комітів і PR:
   ```yaml
   permissions:
     contents: write
     pull-requests: write
   ```


## Швидкий чекліст для налагодження

Під час усунення проблем з перекладом:

1. **Використовуйте debug-режим:** Додайте прапорець `-d` для детальних логів
2. **Перевірте прапорці:** Переконайтеся, що `-md`, `-img`, `-nb` відповідають вашим намірам
3. **Перевірте конфігурацію:** Переконайтеся, що у `.env` файлі є потрібні ключі
4. **Тестуйте поступово:** Почніть з `-md` і поступово додавайте інші типи
5. **Перевірте структуру файлів:** Переконайтеся, що вихідні файли існують і доступні

Для детальнішої інформації про доступні команди та прапорці дивіться [Command Reference](./command-reference.md).

---

**Застереження**:
Цей документ було перекладено за допомогою сервісу автоматичного перекладу [Co-op Translator](https://github.com/Azure/co-op-translator). Хоча ми прагнемо до точності, звертаємо вашу увагу, що автоматичний переклад може містити помилки або неточності. Оригінальний документ мовою оригіналу слід вважати авторитетним джерелом. Для отримання критично важливої інформації рекомендується професійний людський переклад. Ми не несемо відповідальності за будь-які непорозуміння або неправильне тлумачення, що виникли внаслідок використання цього перекладу.