<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "822238e4451d04bb152cebb1be6f13c2",
  "translation_date": "2025-11-30T12:48:07+00:00",
  "source_file": "getting_started/command-reference.md",
  "language_code": "uk"
}
-->
# Довідка по командам

CLI **Co-op Translator** пропонує кілька опцій для налаштування процесу перекладу:

Команда                                      | Опис
---------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
translate -l "language_codes"                 | Перекладає ваш проєкт на вказані мови. Приклад: translate -l "es fr de" перекладає іспанською, французькою та німецькою. Використовуйте translate -l "all" для перекладу на всі підтримувані мови.
translate -l "language_codes" -u              | Оновлює переклади, видаляючи існуючі та створюючи їх заново. Увага: це видалить усі поточні переклади для вказаних мов.
translate -l "language_codes" -img            | Перекладає лише файли зображень.
translate -l "language_codes" -md             | Перекладає лише Markdown-файли.
translate -l "language_codes" -nb             | Перекладає лише файли Jupyter notebook (.ipynb).
translate -l "language_codes" --fix           | Повторно перекладає файли з низьким рівнем довіри на основі попередніх результатів оцінки.
translate -l "language_codes" -d              | Увімкнути режим налагодження для детального логування.
translate -l "language_codes" --save-logs, -s | Зберегти логи рівня DEBUG у файли в <root_dir>/logs/ (консоль залишається під контролем -d)
translate -l "language_codes" -r "root_dir"   | Вказати кореневу директорію проєкту
translate -l "language_codes" -f              | Використовувати швидкий режим для перекладу зображень (до 3 разів швидше, з незначною втратою якості та вирівнювання).
translate -l "language_codes" -y              | Автоматично підтверджувати всі запити (корисно для CI/CD).
translate -l "language_codes" --add-disclaimer/--no-disclaimer | Увімкнути або вимкнути додавання розділу з відмовою від відповідальності за машинний переклад у перекладені markdown та ноутбуки (за замовчуванням увімкнено).
translate -l "language_codes" --help          | Показати довідку по доступних командах у CLI
evaluate -l "language_code"                  | Оцінює якість перекладу для конкретної мови та надає оцінки довіри
evaluate -l "language_code" -c 0.8           | Оцінює переклади з користувацьким порогом довіри
evaluate -l "language_code" -f               | Швидкий режим оцінки (тільки на основі правил, без LLM)
evaluate -l "language_code" -D               | Глибокий режим оцінки (тільки на основі LLM, більш детальний, але повільніший)
evaluate -l "language_code" --save-logs, -s  | Зберегти логи рівня DEBUG у файли в <root_dir>/logs/
migrate-links -l "language_codes"             | Повторно обробити перекладені Markdown-файли для оновлення посилань на ноутбуки (.ipynb). Віддає перевагу перекладеним ноутбукам, якщо вони доступні; інакше може повернутися до оригінальних.
migrate-links -l "language_codes" -r          | Вказати кореневу директорію проєкту (за замовчуванням: поточна директорія).
migrate-links -l "language_codes" --dry-run   | Показати, які файли будуть змінені, без запису змін.
migrate-links -l "language_codes" --no-fallback-to-original | Не переписувати посилання на оригінальні ноутбуки, якщо перекладені відсутні (оновлювати лише, коли перекладені є).
migrate-links -l "language_codes" -d          | Увімкнути режим налагодження для детального логування.
migrate-links -l "language_codes" --save-logs, -s | Зберегти логи рівня DEBUG у файли в <root_dir>/logs/
migrate-links -l "all" -y                      | Обробити всі мови та автоматично підтвердити попередження.

## Приклади використання

  1. Поведінка за замовчуванням (додавати нові переклади без видалення існуючих):   translate -l "ko"    translate -l "es fr de" -r "./my_project"

  2. Додати лише нові переклади зображень корейською (існуючі переклади не видаляються):    translate -l "ko" -img

  3. Оновити всі корейські переклади (Увага: це видалить усі існуючі корейські переклади перед повторним перекладом):    translate -l "ko" -u

  4. Оновити лише корейські зображення (Увага: це видалить усі існуючі корейські зображення перед повторним перекладом):    translate -l "ko" -img -u

  5. Додати нові переклади markdown для корейської без впливу на інші переклади:    translate -l "ko" -md

  6. Виправити переклади з низьким рівнем довіри на основі попередніх результатів оцінки: translate -l "ko" --fix

  7. Виправити переклади з низьким рівнем довіри лише для конкретних файлів (markdown): translate -l "ko" --fix -md

  8. Виправити переклади з низьким рівнем довіри лише для конкретних файлів (зображення): translate -l "ko" --fix -img

  9. Використовувати швидкий режим для перекладу зображень:    translate -l "ko" -img -f

  10. Виправити переклади з низьким рівнем довіри з користувацьким порогом: translate -l "ko" --fix -c 0.8

  11. Приклад режиму налагодження: - translate -l "ko" -d: Увімкнути логування налагодження.
  12. Зберегти логи у файли: translate -l "ko" -s
  13. DEBUG у консолі та у файлах: translate -l "ko" -d -s
  14. Переклад без додавання відмови від відповідальності за машинний переклад: translate -l "ko" --no-disclaimer

  15. Міграція посилань на ноутбуки для корейських перекладів (оновлення посилань на перекладені ноутбуки, якщо доступні):    migrate-links -l "ko"

  15. Міграція посилань з dry-run (без запису файлів):    migrate-links -l "ko" --dry-run

  16. Оновлювати посилання лише коли існують перекладені ноутбуки (не повертатися до оригіналів):    migrate-links -l "ko" --no-fallback-to-original

  17. Обробити всі мови з підтвердженням:    migrate-links -l "all"

  18. Обробити всі мови з автоматичним підтвердженням:    migrate-links -l "all" -y
  19. Зберегти логи у файли для migrate-links:    migrate-links -l "ko ja" -s

### Приклади оцінки

> [!WARNING]  
> **Бета-функція**: Функціонал оцінки наразі знаходиться у бета-версії. Ця функція була випущена для оцінки перекладених документів, а методи оцінки та детальна реалізація ще розробляються і можуть змінюватися.

  1. Оцінити корейські переклади: evaluate -l "ko"

  2. Оцінити з користувацьким порогом довіри: evaluate -l "ko" -c 0.8

  3. Швидка оцінка (тільки на основі правил): evaluate -l "ko" -f

  4. Глибока оцінка (тільки на основі LLM): evaluate -l "ko" -D

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**Відмова від відповідальності**:
Цей документ було перекладено за допомогою сервісу автоматичного перекладу [Co-op Translator](https://github.com/Azure/co-op-translator). Хоча ми прагнемо до точності, будь ласка, майте на увазі, що автоматичні переклади можуть містити помилки або неточності. Оригінальний документ рідною мовою слід вважати авторитетним джерелом. Для критично важливої інформації рекомендується звертатися до професійного людського перекладу. Ми не несемо відповідальності за будь-які непорозуміння або неправильні тлумачення, що виникли внаслідок використання цього перекладу.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->